% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plotTrait}
\alias{plotTrait}
\title{Create faceted plots for every well in a 96-well plate}
\usage{
plotTrait(plate, trait, trait2 = NULL, type = "heat")
}
\arguments{
\item{plate}{a plate data frame, either summarized or unsummarized, to plot}

\item{trait}{the trait to plot in a heat map or histogram or the independent variable in a scatter plot, enter as a string}

\item{trait2}{the trait which will be the dependent variable for the scatter plot, enter as a string}

\item{type}{the type of plot, either "heat" for heatmap, "scatter" for scatter plot, or "hist" for histogram, defaults to "heat"}
}
\description{
Returns ggplot2 object that is faceted by row and column. By default, it will plot a heat map for the trait specified as a string. Other options include scatterplots and histograms.
}
\examples{
#### COPASutils Figures
### Figure 1a
#plotTrait(doseData, trait="TOF", trait2="EXT", type="scatter")

### Figure 1b
#plotTrait(doseData, trait="TOF", type="hist")

### Figure 1c
# sumDose <- summarizePlate(doseData)
# plotTrait(sumDose, trait="n", type="heat")
}

