% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_hv_switchgear_distribution.R
\name{safety_cof_hv_switchgear_distribution}
\alias{safety_cof_hv_switchgear_distribution}
\title{Safety cost of Failure for HV Switchgear Distribution}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
safety_cof_hv_switchgear_distribution(
  hv_asset_category,
  location_risk,
  type_risk
)
}
\arguments{
\item{hv_asset_category}{String The type of HV switchgear distribution asset category
Options: \code{hv_asset_category = c("6.6/11kV CB (GM) Secondary",
"6.6/11kV RMU", "6.6/11kV X-type RMU", "6.6/11kV Switch (GM)",
"20kV CB (GM) Secondary", "20kV RMU", "20kV Switch (GM)")}}

\item{location_risk}{String Type Financial factor criteria for HV switchgear
(cf. section D1.2.1, page 178, CNAIM, 2021).
Options: \code{location_risk = c("Low", "Medium", "High")}.
The default setting is
\code{location_risk = "Medium"}.}

\item{type_risk}{String. Asses Financial factor criteria for HV switchgear
setting (cf. table 221, page 180, CNAIM, 2021).
Options: \code{type_risk = c("Low", "Medium", "High")}.
The default setting is
\code{type_risk = "Medium"}.}
}
\value{
Numeric. Financial consequences of failure for LV switchgear
}
\description{
This function calculates safety consequences of failure
(cf. section 7.3, page 79, CNAIM, 2021). Safetyr consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
safety_cof_hv_switchgear_distribution(
hv_asset_category = "6.6/11kV CB (GM) Secondary",
location_risk = "Default",
type_risk = "Default")
}
