% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_hv_switchgear_distribution.R
\name{environmental_cof_hv_switchgear_distribution}
\alias{environmental_cof_hv_switchgear_distribution}
\title{Environmental cost of Failure for HV switchgear distribution}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
environmental_cof_hv_switchgear_distribution(
  hv_asset_category,
  type_env_factor,
  prox_water,
  bunded
)
}
\arguments{
\item{hv_asset_category}{String The type of HV switchgear distribution asset category
Options: \code{hv_asset_category = c("6.6/11kV CB (GM) Secondary",
"6.6/11kV RMU", "6.6/11kV X-type RMU", "6.6/11kV Switch (GM)",
"20kV CB (GM) Secondary", "20kV RMU", "20kV Switch (GM)")}}

\item{type_env_factor}{String The type environment factor of HV asset category
Options: \code{type_env_factor = c("Oil", "SF6", "Niether", "Default")}.}

\item{prox_water}{Numeric. Specify the proximity to a water course in meters.
A setting of \code{"Default"} will result in a proximity factor of 1. Thus
assume the proximity to a water course is between 80m and 120m
(cf. table 231, page 188, CNAIM, 2021).}

\item{bunded}{String. Options: \code{bunded = c("Yes", "No", "Default")}.
A setting of \code{"Default"} will result in a bunding factor of 1.}
}
\description{
This function calculates environmental consequences of failure
(cf. section 7.3, page 79, CNAIM, 2021). Environmental consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().#' @return Numeric.
Financial consequences of failure for HV switchgear
}
\examples{
environmental_cof_hv_switchgear_distribution(
hv_asset_category = "6.6/11kV CB (GM) Secondary",
type_env_factor = "Oil", prox_water = 95,
bunded = "Yes")
}
