% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.r
\name{ranef.clme}
\alias{ranef.clme}
\alias{ranef.summary.clme}
\alias{random.effects.clme}
\title{Extract random effects}
\usage{
\method{ranef}{clme}(object, ...)

\method{ranef}{summary.clme}(object, ...)

\method{ranef}{clme}(object, ...)

\method{random.effects}{clme}(object, ...)
}
\arguments{
\item{object}{object of class clme.}

\item{...}{space for additional arguments}
}
\value{
Returns a numeric vector.
}
\description{
Extracts the random effects estimates from objects of class \code{clme}.
}
\examples{

data( rat.blood )
cons <- list(order = "simple", decreasing = FALSE, node = 1 )
clme.out <- clme(mcv ~ time + temp + sex + (1|id), data = rat.blood , 
                 constraints = cons, seed = 42, nsim = 0)

ranef( clme.out )


}
\seealso{
\code{\link{CLME-package}}
\code{\link{clme}}
}
