% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readj_multiTrt_att.R
\name{regadj_multiTrt_att}
\alias{regadj_multiTrt_att}
\title{Regression Adjustment when estimand is ATT}
\usage{
regadj_multiTrt_att(y, x, trt, ndpost = 1000)
}
\arguments{
\item{y}{numeric vector for the binary outcome}

\item{x}{dataframe including the treatment indicator and the covariates}

\item{trt}{numeric vector for the treatment indicator}

\item{ndpost}{number of independent simulation draws to create}
}
\value{
list with 2 elements for ATT effect. It contains
\item{ATT12:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
\item{ATT13:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
list with 3 elements for ATE effect. It contains
\item{ATE12:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
\item{ATE13:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
\item{ATE23:}{A dataframe containing the estimation,
standard error, lower and upper 95\% CI for RD/RR/OR}
}
\description{
This function implements the regression adjustment method when estimand is ATT. Please use our main function causal_multi_treat.R.
}
\examples{
library(CIMTx)
set.seed(3242019)
idata = data_gen(n = 12, ratio =1,scenario = 1)
trt_ind <- as.numeric(idata$trtdat$trt_ind)
all_vars <- idata$trtdat[, -1]
y <- idata$Yobs
regadj_multiTrt_att(y = y, x = idata$trtdat,trt = trt_ind)
}
