% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CEOsearch.R
\encoding{UTF-8}
\name{CEOsearch}
\alias{CEOsearch}
\title{Search for keywords in the labels of variables and responses of the survey data}
\usage{
CEOsearch(d, keyword = NULL, where = "variables", translate = FALSE)
}
\arguments{
\item{d}{Microdata retrieved from the CEO using the CEOdata() function. It is a data frame with variable labels.}

\item{keyword}{The character string defining the word / concept to look for within the microdata.}

\item{where}{A character vector specifying if the function should look amongst variable labels ("variables", default), or amongst value labels ("values").}

\item{translate}{Logical. When TRUE, it opens a browser with an automatic translation to English of the variable names and labels using Google Translate. Given the specificity of the terms, only the English translation is provided. Defaults to FALSE.}
}
\value{
A tibble with the set of variables that match the keyword ("Variable"). If the variables are requested, the second variable is their labels ("Label"), and if the values are required the second on is the value labels ("Value").
}
\description{
Easy and convenient access to the metadata of the "Centre
d'Estudis d'Opinio", the Catalan institution for polling and public opinion.
It allows to search for specific terms to obtain the details of the datasets available
}
\examples{
\dontrun{
# Retrieve a dataset to use the function
d <- CEOdata()

# Get the whole set of variable labels
CEOsearch(d)

# Get the whole set of value labels
CEOsearch(d, where = "values")

# Search for specific variable names and variable labels with the string "edat" (age).
CEOsearch(d, keyword = "edat")

# Search for specific variable names and variable labels with the string "edat" (age),
# and translate the results to English.
CEOsearch(d, keyword = "edat", translate = TRUE)

# now for the combination of "valoracio" OR "covid" OR "govern".
CEOsearch(d, keyword = c("valoració", "covid",  "govern"))
}
}
