% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CEOdata.R, R/help.R
\docType{package}
\encoding{UTF-8}
\name{CEOdata}
\alias{CEOdata}
\title{Import datasets / microdata from the "Centre d'Estudis d'Opinio"}
\usage{
CEOdata(
  kind = "barometer",
  reo = NA,
  raw = FALSE,
  complementary_variables = TRUE,
  date_start = NA,
  date_end = NA
)
}
\arguments{
\item{kind}{Character vector with the sort of microdata required. Defaults to "barometer", that contains the whole set of Barometers from 2014 (presential interviews). "barometer_until_2013" contains the interviews performed by phone until 2013, with a somewhat different questionnaire and structure. For such dataset you need a third-party software installed in your computer to be able to uncompress the RAR original file.}

\item{reo}{Character vector of length one that allows to get the dataset of a specific REO (Registre d'Estudis d'Opinio, the internal register ID used by the CEO) to download. By default (when \code{reo = NA}) it uses the \code{kind} argument.}

\item{raw}{Logical value to indicate if SPSS labels are transformed into factors. Defaults to TRUE. Otherwise it returns the matrices as imported by haven::read_spss(). Does not apply to data from singular REOs.}

\item{complementary_variables}{Logical value as to whether include (default) complementary variables such as date (Data). Defaults to TRUE. Names of such new variables only use upper case in the first letter. Complementary variables are added at the end. Does not apply to data from singular REOs.}

\item{date_start}{Character vector with a starting date ("DD-MM-YYYY") for the data.}

\item{date_end}{Character vector with an end date ("DD-MM-YYYY") for the data.}
}
\value{
A tibble with the individuals' responses to the questionnaire retrieved.
}
\description{
Easy and convenient access to the datasets / microdata of the "Centre
d'Estudis d'Opinio", the catalan institution for polling and public opinion.
The package uses the data stored in the servers of the CEO and returns it in
a tidy format (tibble).

Easy and convenient access to the datasets / microdata of the "Centre
d'Estudis d'Opinio", the catalan institution for polling and public opinion.
The package uses the data stored in the servers of the CEO and returns it in
a tidy format (tibble).
}
\examples{
\dontrun{
d <- CEOdata()

# Get the number of individuals surveyed and the number of variables recorded.
dim(d)

# Get the identifiers of the different Barometers retrieved
unique(d$BOP_NUM)
}
}
\references{
\url{http://xavier-fim.net/packages/CEOdata/}.
}
