% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numericDistances.R
\name{distanceNumericLCStr}
\alias{distanceNumericLCStr}
\title{Longest Common Substring for Numeric Vectors}
\usage{
distanceNumericLCStr(x, y)
}
\arguments{
\item{x}{first vector (numeric)}

\item{y}{second vector (numeric)}
}
\value{
numeric distance value \deqn{d(x,y)}, scaled to values between 0 and 1
}
\description{
Longest common substring distance for two numeric vectors, e.g., bit vectors.
}
\examples{
#e.g., used for distance between bit strings
x <- c(0,1,0,1,0)
y <- c(1,1,0,0,1)
distanceNumericLCStr(x,y)
p <- replicate(10,sample(c(0,1),5,replace=TRUE),simplify=FALSE)
distanceMatrix(p,distanceNumericLCStr)

}
