% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indefiniteLearning.R
\name{correctionKernelMatrix}
\alias{correctionKernelMatrix}
\title{Correction of a Kernel (Correlation) Matrix}
\usage{
correctionKernelMatrix(mat, method = "flip", repair = TRUE,
  tol = 1e-08)
}
\arguments{
\item{mat}{symmetric kernel matrix}

\item{method}{string that specifies method for correction: spectrum clip \code{"clip"}, spectrum flip \code{"flip"}, nearest definite matrix \code{"near"}, spectrum square\code{"square"}, spectrum diffusion \code{"diffusion"}.}

\item{repair}{boolean, whether or not to use condition repair, so that elements between -1 and 1, and the diagonal values are 1.}

\item{tol}{torelance value. Eigenvalues between \code{-tol} and \code{tol} are assumed to be zero.}
}
\value{
list with corrected kernel matrix \code{mat}, \code{isPSD} (boolean, whether original matrix was PSD), transformation matrix \code{A},
the matrix of eigenvectors (\code{U}) and the transformation vector (\code{a})
}
\description{
Convert a non-PSD kernel matrix with chosen approach so that it becomes a PSD matrix.
Optionally, the resulting matrix is enforced to have values between -1 and 1 and a diagonal of 1s, with the \code{repair} parameter.
That means, it is (optionally) converted to a valid correlation matrix.
Essentially, this is a combination of \code{\link{correctionDefinite}} with \code{\link{repairConditionsCorrelationMatrix}}.
}
\examples{
x <- list(c(2,1,4,3),c(2,4,3,1),c(4,2,1,3),c(4,3,2,1),c(1,4,3,2))
D <- distanceMatrix(x,distancePermutationInsert)
K <- exp(-0.01*D)
is.PSD(K) #matrix should not be PSD
K <- correctionKernelMatrix(K)$mat
is.PSD(K) #matrix should now be CNSD
K
}
\references{
Martin Zaefferer and Thomas Bartz-Beielstein. (2016). Efficient Global Optimization with Indefinite Kernels. Parallel Problem Solving from Nature-PPSN XIV. Accepted, in press. Springer.
}
\seealso{
\code{\link{correctionDefinite}}, \code{\link{repairConditionsCorrelationMatrix}}
}
