% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/permutationDistances.r
\name{distancePermutationManhattan}
\alias{distancePermutationManhattan}
\title{Manhattan Distance for Permutations}
\usage{
distancePermutationManhattan(x, y)
}
\arguments{
\item{x}{first permutation (integer vector)}

\item{y}{second permutation (integer vector)}
}
\value{
numeric distance value \deqn{d(x,y)}, scaled to values between 0 and 1 (based on the maximum possible distance between two permutations)
}
\description{
Manhattan distance for permutations, scaled to values between 0 and 1:
\deqn{d(x,y) = frac(1){r} \sum_{i=1}^n |x_i - y_i| }{ d(x,y) = 1/r * \sum_{i=1}^n  |x_i - y_i|}
where n is the length of the permutations x and y, and scaling factor \eqn{r=(n^2-1)/2} (if n is odd)
or \eqn{r=((n^2)/2} (if n is even).
}
\examples{
x <- 1:5
y <- c(5,1,2,3,4)
distancePermutationManhattan(x,y)
p <- replicate(10,sample(1:5),simplify=FALSE)
distanceMatrix(p,distancePermutationManhattan)
}

