% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visR.R
\name{visr.omop_attrition}
\alias{visr.omop_attrition}
\title{Create an attrition diagram from a generated cohort set}
\usage{
visr.omop_attrition(x, ...)
}
\arguments{
\item{x}{A GeneratedCohortSet object}

\item{...}{Not used

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}}
}
\value{
No return value. This function will create one attrition plot for each generated cohort.
}
\description{
Create an attrition diagram from a generated cohort set
}
\examples{
\dontrun{
library(CDMConnector)
library(dplyr)

con <- DBI::dbConnect(duckdb::duckdb(), eunomia_dir())
cdm <- cdm_from_con(con, "main", "main")
cohort_set <- read_cohort_set(system.file("cohorts2", package = "CDMConnector"))
cdm <- generate_cohort_set(cdm, cohort_set, name = "cohort", overwrite = T)

cohort_attrition(cdm$cohort) \%>\%
 dplyr::filter(cohort_definition_id == 3) \%>\%
 visR::visr()

DBI::dbDisconnect(con, shutdown = TRUE)
}

}
\keyword{internal}
