% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCAMLRGIS_DataDescription.R
\docType{data}
\name{SmallBathy}
\alias{SmallBathy}
\title{Small bathymetry dataset}
\format{
raster
}
\usage{
data(SmallBathy)
}
\description{
Bathymetry dataset derived from the GEBCO 2021 (see \url{https://www.gebco.net/}) dataset.
Subsampled at a 10,000m resolution. Projected using the CCAMLR standard projection (\code{\link{CCAMLRp}}).
To highlight the Fishable Depth range, use \code{\link{Depth_cols2}} and \code{\link{Depth_cuts2}}.
\strong{To be only used for large scale illustrative purposes. Please refer to \code{\link{load_Bathy}}
to get higher resolution data.}
}
\examples{
plot(SmallBathy,breaks=Depth_cuts,col=Depth_cols,axes=FALSE,box=FALSE)
}
\references{
GEBCO Compilation Group (2021) GEBCO 2021 Grid (doi:10.5285/c6612cbe-50b3-0cff-e053-6c86abc09f8f)
}
\seealso{
\code{\link{load_Bathy}}, \code{\link{add_col}}, \code{\link{add_Cscale}}, \code{\link{Depth_cols}},
\code{\link{Depth_cuts}},
\code{\link{Depth_cols2}}, \code{\link{Depth_cuts2}}, \code{\link{get_depths}}, \code{\link{create_Stations}}.
}
