% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_depths.R
\name{get_depths}
\alias{get_depths}
\title{Get depths of locations from bathymetry raster}
\usage{
get_depths(
  Input,
  Bathy,
  d = 10000,
  Isobaths = NA,
  IsoLocs = FALSE,
  ShowProgress = FALSE
)
}
\arguments{
\item{Input}{dataframe with, at least, Latitudes and Longitudes.
\strong{The columns in the \code{Input} must be in the following order:

Latitude, Longitude, Variable 1, Variable 2, ... Variable x}}

\item{Bathy}{bathymetry raster with the appropriate \code{\link[CCAMLRGIS:CCAMLRp]{projection}},
such as \code{\link[CCAMLRGIS:SmallBathy]{this one}}. It is recommended to use a raster of higher
resolution than \code{\link{SmallBathy}}.}

\item{d}{distance in meters, used to group locations by distance and speed up computations (by cutting
the bathymetry raster into small pieces matching the extent of grouped locations). Lower values
make computations faster but at the risk of not finding distances to isobaths (when desired).}

\item{Isobaths}{Depths to which the horizontal distances to locations are computed, if required.}

\item{IsoLocs}{If \code{TRUE}, the locations on the \code{Iosbaths} that are closest to the
locations given in the \code{Input} are added to the exported dataframe.}

\item{ShowProgress}{if set to \code{TRUE}, a progress bar is shown (\code{get_depths} may take a while).}
}
\value{
dataframe with the same structure as the \code{Input} with additional columns, where 
\code{'x'} and \code{'y'} are the projected locations, \code{'d'} is the depth,
\code{'D_iso'}, \code{'X_iso'} and \code{'Y_iso'} are the horizontal distances and 
closest point location on \code{'Isobaths'}. All units are in meters.
}
\description{
Given a bathymetry raster and an input dataframe of point locations (given in decimal degrees),
computes the depths at these locations using bilinear interpolation (using \code{\link[raster]{extract}}).
Optionally can also compute the horizontal distance of locations to chosen isobaths.
}
\examples{
\donttest{


#Generate a dataframe
MyData=data.frame(Lat=PointData$Lat,
Lon=PointData$Lon,
Catch=PointData$Catch)

#Example 1: get depths of locations
MyDataD=get_depths(MyData,SmallBathy)
#View(MyDataD)
plot(MyDataD$d,MyDataD$Catch,xlab='Depth',ylab='Catch',pch=21,bg='blue') #Plot of catch vs depth

#Example 2: get depths of locations and distance to isobath -3000m

MyDataD=get_depths(MyData,SmallBathy,Isobaths=-3000,IsoLocs=TRUE,d=200000,ShowProgress=TRUE)
plot(MyDataD$x,MyDataD$y,pch=21,bg='green')
contour(SmallBathy,levels=-3000,add=TRUE,col='blue',maxpixels=10000000)
segments(x0=MyDataD$x,
         y0=MyDataD$y,
         x1=MyDataD$X_3000,
         y1=MyDataD$Y_3000,col='red')


}

}
\seealso{
\code{\link{SmallBathy}}, \code{\link{create_Points}}, \code{\link{create_Stations}}, \code{\link[raster]{extract}}.
}
