% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{print.cbtf}
\alias{print.cbtf}
\title{Print the results from a fuzz run}
\usage{
\method{print}{cbtf}(x, show_all = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{cbtf}.}

\item{show_all}{Whether all results should be printed. By default (\code{FALSE}),
only the functions that reported an error or a warning are printed.
If \code{TRUE}, all functions tested are printed, including those that
were successful or were skipped.}

\item{...}{Further arguments passed to or from other methods.
These are currently ignored.}
}
\value{
No return value, called for side effects.
}
\description{
This formats with colours the results from a fuzz run and prints them to
the terminal.
}
\examples{
res <- fuzz(funs = c("list", "matrix", "mean"),
            what = test_inputs(c("numeric", "raw")))
print(res, show.all = TRUE)

}
\seealso{
\link{summary.cbtf}
}
