% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale.R
\name{rescale}
\alias{rescale}
\title{Rescaling row/column categories coordinates between a minimum and maximum
value}
\usage{
rescale(data, x = 1, which = "rows", min.v = 0, max.v = 100)
}
\arguments{
\item{data}{Name of the dataset (must be in dataframe format).}

\item{x}{Dimension for which the row categories contribution is returned (1st
dimension by default).}

\item{which}{Speficy if rows ("rows", default) or columns ("cols") must be
grouped.}

\item{min.v}{Minimum value of the new scale (0 by default).}

\item{max.v}{Maximum value of the new scale (100 by default).}
}
\description{
This function allows to rescale the coordinates of a selected dimension to be
constrained between a minimum and a maximum user-defined value.
}
\details{
The rationale of the function is that users may wish to use the coordinates
on a given dimension to devise a scale, along the lines of what is
accomplished in:\cr Greenacre M 2002, "The Use of Correspondence Analysis in
the Exploration of Health Survey Data", Documentos de Trabajo 5, Fundacion
BBVA, pp. 7-39\cr The function returns a chart representing the row/column
categories against the rescaled coordinates from the selected dimension. A
dataframe is also returned containing the original values (i.e., the
coordinates) and the corresponding rescaled values.
}
\examples{
data(greenacre_data)

#rescale the row coordinates between 0 and 10
res <- rescale(greenacre_data, which="rows", min.v=0, max.v=10)

}
\keyword{rescale}
