% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitSamples.R
\name{splitSamples}
\alias{splitSamples}
\title{splitSamples}
\usage{
splitSamples(x, y, z, agg.radius = agg.radius)
}
\arguments{
\item{x}{A \emph{SpatialPoints} or a \emph{SpatialPolygons} object.}

\item{y}{A \emph{RasterLayer}.}

\item{z}{A vector.}

\item{agg.radius}{Numeric element.}
}
\value{
A list.
}
\description{
Aggregates a spatial object into regions.
}
\details{
{For each class in \emph{z}, the function converts the elements in \emph{x} into a raster layer using \emph{y} as a basis. Then, 
it aggregates all pixels that are within a given distance of each other - defined by \emph{agg.radius} using \code{\link{ccLabel}}. The 
output is a list consisting of:
\itemize{
 \item{\emph{region.id} - Class dependent region label for each element in \emph{x}.}
 \item{\emph{region.frequency} - Pixel count for each unique value in \emph{region.id}.}}}
}
\examples{
{

require(raster)
require(fieldRS)

# read raster data
r <- brick(system.file("extdata", "ndvi.tif", package="fieldRS"))

# read field data
data(fieldData)
fieldData <- fieldData[3:4,]

# find polygon clusters
k <- splitSamples(fieldData, r, fieldData$crop, agg.radius=30)
fieldData$ID <- as.factor(k$region.id)

# plot regions with labels
spplot(fieldData["ID"])

# show pixel count per region
head(k$region.frequency)

}
}
\seealso{
\code{\link{phenoCropVal}} \code{\link{phenoCropClass}}
}
