#' summary.CAISErPowercurve
#'
#' S3 method for summarizing _caiser.powercurve_ objects (the output of
#' [calc_power_curve()]).
#'
#' @param object list object of class _caiser.powercurve_
#'                     (generated by [calc_power_curve()])
#' @param highlights specific power values to highlight
#' @param ... other parameters to be passed down to specific summary
#'            functions (currently unused)
#'
#' @examples
#' my.cpc <- calc_power_curve(ninstances = 10)
#' summary(my.cpc)
#'
#' @export
#'
#' @method summary CAISErPowercurve

# TESTED
summary.CAISErPowercurve <- function(object,
                                     highlights = c(.5, .8, .95),
                                     ...)
{

  # ========== Error catching ========== #
  assertthat::assert_that(
    "CAISErPowercurve" %in% class(object),
    length(object$d) == length(object$power),
    is.numeric(highlights),
    length(highlights) > 0,
    all(highlights > 0),
    all(highlights < 1))
  # ==================================== #

  npts <- length(object$d)

  output <- data.frame(d     = numeric(),
                       power = numeric())
  cat("#====================================")
  cat("\n Number of points: ", npts)

  for (i in seq_along(highlights)){
    indx <- which.min(abs(object$power - highlights[i]))
    cat("\n power = ", signif(object$power[indx], 2),
        "for d = ", signif(object$d[indx], 2))
    output <- rbind(output,
                    data.frame(d     = object$d[indx],
                               power = object$power[indx]))
  }
  cat("\n#====================================")

  # i50 <- which.min(abs(object$power - 0.50))
  # i80 <- which.min(abs(object$power - 0.80))
  # i95 <- which.min(abs(object$power - 0.95))
  #
  #
  # cat("\n power = ", signif(object$power[i50], 2),
  #     "for d = ", signif(object$d[i50], 2))
  # cat("\n power = ", signif(object$power[i80], 2),
  #     "for d = ", signif(object$d[i80], 2))
  # cat("\n power = ", signif(object$power[i95], 2),
  #     "for d = ", signif(object$d[i95], 2))
  # cat("\n#====================================")
  #
  # output <- data.frame(d     = c(object$d[i50],
  #                                object$d[i80],
  #                                object$d[i95]),
  #                      power = c(object$power[i50],
  #                                object$power[i80],
  #                                object$power[i95]))
  invisible(output)
}
