/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.prefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import org.neptuneinc.cadstat.prefs.CadstatPreferences;
import org.neptuneinc.cadstat.prefs.DataPointColor;
import org.neptuneinc.cadstat.prefs.PlotCharacter;

public class PreferencesManager {
    private File prefsFile;
    private Preferences prefs;
    private CadstatPreferences cadstatPrefs;

    public PreferencesManager() {
        this.setPreferences(Preferences.userNodeForPackage(CadstatPreferences.class));
        this.setCadstatPreferences(new CadstatPreferences());
        this.setPreferencesFile(new File(System.getProperty("user.home") + File.separator + ".cadstat", "preferences.xml"));
    }

    public PreferencesManager(File prefsFile) {
        this.setPreferences(Preferences.userNodeForPackage(CadstatPreferences.class));
        this.setCadstatPreferences(new CadstatPreferences());
        this.setPreferencesFile(prefsFile);
    }

    public void importPreferences() throws FileNotFoundException, IOException, InvalidPreferencesFormatException {
        try {
            Preferences.importPreferences(new FileInputStream(this.getPreferencesFile()));
        }
        catch (FileNotFoundException e) {
            System.out.println("Preferences file not found at '" + this.getPreferencesFile().getAbsolutePath() + "'. Using default preferences.");
        }
        this.getCadstatPreferences().setDataPointColor(DataPointColor.valueOf(this.getPreferences().get("DataPointColor", DataPointColor.BLACK.name())));
        this.getCadstatPreferences().setPlotCharacter(PlotCharacter.valueOf(this.getPreferences().get("PlotChar", PlotCharacter.OPEN_CIRCLE.name())));
        this.getCadstatPreferences().setPlotTitleMagnification(Float.valueOf(this.getPreferences().getFloat("PlotTitleMag", CadstatPreferences.DEFAULT_MAGNIFICATION.floatValue())));
        this.getCadstatPreferences().setAxisMagnification(Float.valueOf(this.getPreferences().getFloat("AxisMag", CadstatPreferences.DEFAULT_MAGNIFICATION.floatValue())));
        this.getCadstatPreferences().setAxisLabelMagnification(Float.valueOf(this.getPreferences().getFloat("AxisLabelMag", CadstatPreferences.DEFAULT_MAGNIFICATION.floatValue())));
        this.getCadstatPreferences().setDataPointMagnification(Float.valueOf(this.getPreferences().getFloat("DataPointMag", CadstatPreferences.DEFAULT_MAGNIFICATION.floatValue())));
    }

    public void exportPreferences() throws FileNotFoundException, IOException, BackingStoreException {
        if (this.getPreferencesFile() != null && !this.getPreferencesFile().exists()) {
            this.getPreferencesFile().getParentFile().mkdirs();
            this.getPreferencesFile().createNewFile();
        }
        this.getPreferences().put("DataPointColor", this.getCadstatPreferences().getDataPointColor().name());
        this.getPreferences().put("PlotChar", this.getCadstatPreferences().getPlotCharacter().name());
        this.getPreferences().putFloat("PlotTitleMag", this.getCadstatPreferences().getPlotTitleMagnification().floatValue());
        this.getPreferences().putFloat("AxisMag", this.getCadstatPreferences().getAxisMagnification().floatValue());
        this.getPreferences().putFloat("AxisLabelMag", this.getCadstatPreferences().getAxisLabelMagnification().floatValue());
        this.getPreferences().putFloat("DataPointMag", this.getCadstatPreferences().getDataPointMagnification().floatValue());
        this.getPreferences().exportSubtree(new FileOutputStream(this.getPreferencesFile()));
    }

    public Preferences getPreferences() {
        return this.prefs;
    }

    public void setPreferences(Preferences prefs) {
        this.prefs = prefs;
    }

    public File getPreferencesFile() {
        return this.prefsFile;
    }

    public void setPreferencesFile(File prefsFile) {
        this.prefsFile = prefsFile;
    }

    public CadstatPreferences getCadstatPreferences() {
        return this.cadstatPrefs;
    }

    public void setCadstatPreferences(CadstatPreferences cadstatPrefs) {
        this.cadstatPrefs = cadstatPrefs;
    }
}

