% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-setGeneric.R, R/S4-BuyseTest-sensitivity.R
\docType{methods}
\name{sensitivity}
\alias{sensitivity}
\alias{S4BuyseTest-sensitivity}
\alias{sensitivity,S4BuyseTest-method}
\title{Sensitivity Analysis for the Choice of the Thresholds}
\usage{
sensitivity(object, ...)

\S4method{sensitivity}{S4BuyseTest}(
  object,
  threshold,
  statistic = NULL,
  band = FALSE,
  conf.level = NULL,
  null = NULL,
  transformation = NULL,
  alternative = NULL,
  adj.p.value = FALSE,
  trace = TRUE,
  cpus = 1,
  ...
)
}
\arguments{
\item{object}{an \R object of class \code{\linkS4class{S4BuyseTest}}, i.e., output of \code{\link{BuyseTest}}}

\item{...}{argument passsed to the function \code{transformCIBP} of the riskRegression package.}

\item{threshold}{[list] a list containing for each endpoint the thresholds to be considered.}

\item{statistic}{[character] the statistic summarizing the pairwise comparison:
\code{"netBenefit"} displays the net benefit, as described in Buyse (2010) and Peron et al. (2016)),
\code{"winRatio"} displays the win ratio, as described in Wang et al. (2016),
\code{"favorable"} displays the proportion in favor of the treatment (also called Mann-Whitney parameter), as described in Fay et al. (2018).
\code{"unfavorable"} displays the proportion in favor of the control.
Default value read from \code{BuyseTest.options()}.}

\item{band}{[logical] should simulateneous confidence intervals be computed?}

\item{conf.level}{[numeric] confidence level for the confidence intervals.
Default value read from \code{BuyseTest.options()}.}

\item{null}{[numeric] right hand side of the null hypothesis (used for the computation of the p-value).}

\item{transformation}{[logical]  should the CI be computed on the logit scale / log scale for the net benefit / win ratio and backtransformed.
Otherwise they are computed without any transformation.
Default value read from \code{BuyseTest.options()}. Not relevant when using permutations or percentile bootstrap.}

\item{alternative}{[character] the type of alternative hypothesis: \code{"two.sided"}, \code{"greater"}, or \code{"less"}.
Default value read from \code{BuyseTest.options()}.}

\item{adj.p.value}{[logical] should p-value adjusted for multiple comparisons be computed?}

\item{trace}{[logical] Should the execution of the function be traced?}

\item{cpus}{[integer, >0] the number of CPU to use. Default value is 1.}
}
\description{
Evaluate the statistic of interest along various thresholds of clinical relevance.
}
\details{
Simulateneous confidence intervals and adjusted p-values are computed using a single-step max-test approach via the function \code{transformCIBP} of the riskRegression package.
}
\examples{

\dontrun{
## simulate data
set.seed(10)
df.data <- simBuyseTest(1e2, n.strata = 2)

## with one endpoint
ff1 <- treatment ~ TTE(eventtime, status = status, threshold = 0.1)
BT1 <- BuyseTest(ff1, data= df.data)
se.BT1 <- sensitivity(BT1, threshold = seq(0,2,0.25), band = TRUE)
autoplot(se.BT1)

## with two endpoints
ff2 <- update(ff1, .~. + cont(score, threshold = 1))
BT2 <- BuyseTest(ff2, data= df.data)
se.BT2 <- sensitivity(BT2, threshold = list(eventtime = seq(0,2,0.25), score = 0:2),
                      band = TRUE)
autoplot(se.BT2)
autoplot(se.BT2, col = NA)
}
}
