% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.R
\name{Buddle_Main}
\alias{Buddle_Main}
\title{Building a multi-layer feed-forward neural network model for statistical classification}
\usage{
Buddle_Main(Data, Label, Train_Size, Batch_Size, Optimization = "SGD",
  Learning_Rate = 0.05, Iteration = 100, Layer = 3, Neuron = 20,
  Activation = "Sigmoid")
}
\arguments{
\item{Data}{- Input matrix.}

\item{Label}{- Vector of training labels.}

\item{Train_Size}{- Size of data which is used for training .}

\item{Batch_Size}{- Batch size.}

\item{Optimization}{- Method used to minimize loss fucntion. It can take one of "SGD", "Moment", or "AdaGrad."}

\item{Learning_Rate}{- Default is 0.05.}

\item{Iteration}{- Number of iterations. Default is 100.}

\item{Layer}{- Number of layers. Default is 3.}

\item{Neuron}{- Number of neurons. Default is 20.}

\item{Activation}{- The name of activation function. It takes either "Relu" or "Sigmoid."}
}
\value{
Loss         - Vector of values of the loss function.

W            - Matrix of weights in the first layer

b            - Vector of weights in the first layer

ZList        - List of matrices of weights in the middle layers

cList        - List of vectors of weights in the middle layers

ZFinal       - Matrix of weights in the final layer

cFinal       - Vector of weights in the final layer

Train_acc    - Accuracy of the classifier when applied to the train data

Test_acc     - Accuracy of the classifier when applied to the test data

Epoch        - Number of epoch.
}
\description{
Building a multi-layer feed-forward neural network model for statistical classification
}
\examples{
####################
n <- 50
p <- 3
Data <- matrix(runif(n*p, 0,50), nrow=n, ncol=p)  #### Generate n-by-p input matrix for data
Label = sample.int(n, n, replace=TRUE)            #### Generate n-by-1 vector for the label
Layer = 6                                      #### Number of layers
Neuron = 20                                    #### Number of neurons
lr = 0.005                                     #### Learning rate 
Iter = 100                                #### Iteration
Opt = "SGD"                              #### Method to optimize the loss function
Act = "Sigmoid"                          ##### Activation function
TrSize = 20                              ##### Train_Size
BatSize = 5                               ##### Batch_Size
DLResult = Buddle_Main(Data, Label, TrSize, BatSize, Opt, lr, Iter, Layer, Neuron, Act)
Loss_Vector = DLResult$Loss
Train_Accuracy = DLResult$Train_acc
Test_Accuracy = DLResult$Test_acc
}
\references{
[1] Geron, A. Hand-On Machine Learning with Scikit-Learn and TensorFlow. Sebastopol: O'Reilly, 2017. Print.

[2] Han, J., Pei, J, Kamber, M. Data Mining: Concepts and Techniques. New York: Elsevier, 2011. Print.
}
\seealso{
Buddle_Predict
}
