\name{attStats}
\alias{attStats}
 
\title{Attribute statistics}
\description{
  \code{attStats} shows a summary of a Boruta run in an attribute-centred way. It produces a data frame containing some ZScore
  stats as well as the number of hits that attribute scored and the decision it was given.  
}

\usage{
attStats(x)
}

\arguments{
 \item{x}{an object of class \code{Boruta}.}
}

\value{
  A data frame containing, for each attribute that was originally in information system,
  mean, median, maximal and minimal ZScore,  number of hits normalised to number of random
  forest runs performed and the decision copied from \code{finalDecision}.
}

\note{
 When using a Boruta object generated by a \code{\link{TentativeRoughFix}}, the resulting data frame will consist a rough fixed
 decision.
}

\examples{
\dontrun{
library(mlbench); data(Sonar);
#Takes some time, so be patient
Boruta(Class~.,data=Sonar,doTrace=2)->Bor.son;
print(Bor.son);
stats<-attStats(Bor.son);
print(stats);
plot(normHits~meanZ,col=stats$decision,data=stats);
}
}



\author{Miron B. Kursa}


