% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metricsBioTIME.R
\name{getAlphaMetrics}
\alias{getAlphaMetrics}
\title{Alpha diversity metrics}
\usage{
getAlphaMetrics(x, measure)
}
\arguments{
\item{x}{(\code{data.frame}) BioTIME data table in the format of the output of the
\code{\link{gridding}} function and/or \code{\link{resampling}} function.}

\item{measure}{(\code{character}) chosen currency defined by a single column name.}
}
\value{
Returns a data frame with results for species richness (\code{S}), numerical
 abundance (\code{N}), maximum numerical abundance (\code{MaxN}), Shannon Index (\code{Shannon}),
 Exponential Shannon (\code{expShannon}), Simpson's Index (Simpson), Inverse Simpson
 (\code{InvSimpson}), Probability of intraspecific encounter (\code{PIE}) and McNaughton's
 Dominance (\code{DomMc}) for each year and \code{assemblageID}.
}
\description{
Calculates a set of standard alpha diversity metrics
}
\details{
The function \code{getAlphaMetrics} computes nine alpha diversity metrics for
a given community data frame, where \code{measure} is a character input
specifying the abundance or biomass field used for the calculations. For each
row of the data frame with data, \code{getAlphaMetrics} calculates
the following metrics:

- Species richness (\code{S}) as the total number of species in each year with currency > 0.

- Numerical abundance (\code{N}) as the total currency (sum) in each year
(either total abundance or total biomass).

- Maximum Numerical abundance (MaxN) as the highest currency value reported in each year.

- Shannon or Shannon–Weaver index is calculated as \eqn{\sum_{i}p_{i}log_{b}p_{i}}, where \eqn{p_{i}} is the proportional abundance of species i and b is the base of the logarithm (natural logarithms), while exponential Shannon is given by \code{exp(Shannon)}.

- Simpson's index is calculated as \eqn{1-sum(p_{i}^{2})}, while Inverse Simpson as \eqn{1/sum(p_{i}^{2})}.

- McNaughton's Dominance is calculated as the sum of the pi of the two most abundant species.

- Probability of intraspecific encounter or PIE is calculated as \eqn{\left(\frac{N}{N-1}\right)\left(1-\sum_{i=1}^{S}\pi_{i}^{2}\right)}.

Note that the input data frame needs to be in the format of the output of the
 \code{\link{gridding}} function and/or \code{\link{resampling}} functions,
 which includes keeping the default BioTIME data column names. If such columns
 are not found an error is issued and the computations are halted.
}
\examples{
  x <- data.frame(
    resamp = 1L,
    YEAR = rep(rep(2010:2015, each = 4), times = 4),
    Species = c(replicate(n = 8L, sample(letters, 24L, replace = FALSE))),
    ABUNDANCE = rpois(24 * 8, 10),
    assemblageID = rep(LETTERS[1L:8L], each = 24)
  )
  res <- getAlphaMetrics(x, measure = "ABUNDANCE")
}
