% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{gam_ctr_plot}
\alias{gam_ctr_plot}
\title{GAM Contrast Plot}
\usage{
gam_ctr_plot(
  yvar,
  censorvar = NULL,
  xvar,
  xvars.adj = NULL,
  sxvars.adj = NULL,
  trtvar = NULL,
  type,
  data,
  k,
  title = "Group Contrast",
  ybreaks = NULL,
  xbreaks = NULL,
  rugcol.var = NULL,
  link.scale = TRUE,
  prt.sum = TRUE,
  prt.chk = FALSE,
  outlier.rm = FALSE
)
}
\arguments{
\item{yvar}{Response variable name.}

\item{censorvar}{Censoring variable name (0-censored, 1-event). Required if type is "s" (survival).}

\item{xvar}{Biomarker name.}

\item{xvars.adj}{Potential confounding variables to adjust for using linear terms.}

\item{sxvars.adj}{Potential confounding variables to adjust for using curves.}

\item{trtvar}{Treatment variable that the contrast will build upon (treatment-control).}

\item{type}{Type of response variable. Options are "c" for continuous, "s" for survival, and "b" for binary response.}

\item{data}{The dataset containing the variables.}

\item{k}{Upper limit on the degrees of freedom associated with an s smooth.When this k is too large, program will report error saying}

\item{title}{Title of the plot.}

\item{ybreaks}{Breaks on the y-axis.}

\item{xbreaks}{Breaks on the x-axis.}

\item{rugcol.var}{Variable name that defines the color of the rug.}

\item{link.scale}{Whether to show the plot (y-axis) in the scale of the link function (linear predictor).}

\item{prt.sum}{Whether to print summary or not.}

\item{prt.chk}{Whether to print model diagnosis.}

\item{outlier.rm}{Whether to remove outliers based on 1.5IQR.}
}
\value{
A list containing the p-value table, summarized p-value table, s-value table, summarized s-value table, and the plot.
}
\description{
Computes and plots the contrasts between treatment and control group based on a GAM for exploring the relationship be-tween treatment benefit and biomarker.
}
