% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/475-extractDrugMACCS.R
\name{extrDrugMACCSComplete}
\alias{extrDrugMACCSComplete}
\title{Calculate the MACCS Molecular Fingerprints (in Complete Format)}
\usage{
extrDrugMACCSComplete(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process 
should be shown or not, default is \code{TRUE}.}
}
\value{
An integer vector or a matrix. Each row represents one molecule, 
the columns represent the fingerprints.
}
\description{
Calculate the MACCS Molecular Fingerprints (in Complete Format)
}
\details{
The popular 166 bit MACCS keys described by MDL.
}
\examples{
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
fp  = extrDrugMACCSComplete(mol)
dim(fp)

}
\seealso{
\link{extrDrugMACCS}
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{extrDrugMACCSComplete}
