% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1103-rffs.R
\name{rf.fs}
\alias{rf.fs}
\title{Random Forest Cross-Valdidation for feature selection}
\usage{
rf.fs(trainx, trainy, cv.fold = 5, scale = "log", step = 0.5,
  mtry = function(p) max(1, floor(sqrt(p))), recursive = FALSE)
}
\arguments{
\item{trainx}{matrix or data frame containing columns of predictor variables}

\item{trainy}{vector of response, must have length equal to the number of rows in 
\code{trainx}}

\item{cv.fold}{The fold, the defalut is 5.}

\item{scale}{If \code{"log"}, reduce a fixed proportion (\code{step}) of variables 
at each step, otherwise reduce \code{step} variables at a time}

\item{step}{If \code{log=TRUE}, the fraction of variables to remove at each step, 
else remove this many variables at a time}

\item{mtry}{A function of number of remaining predictor variables to use as the 
\code{mtry} parameter in the \code{randomForest} call}

\item{recursive}{Whether variable importance is (re-)assessed at each step of variable 
reduction}
}
\value{
A list with the following three components::
\itemize{
\item \code{n.var} - vector of number of variables used at each step
\item \code{error.cv} - corresponding vector of error rates or MSEs at each step
\item \code{res} - list of n.var components, each containing the feature importance values from 
the cross-validation
}
}
\description{
Random Forest Cross-Valdidation for feature selection
}
\details{
This function shows the cross-validated prediction performance of models with 
sequentially reduced number of predictors (ranked by variable importance) via 
a nested cross-validation procedure.
}
\examples{
training = read.csv(system.file('sysdata/training1.csv', package = 'BioMedR'), header = TRUE)
y = training[, 1]
x = training[, -1]
result = rf.fs(x, y)

}
\references{
Svetnik, V., Liaw, A., Tong, C. and Wang, T., Application of Breiman's Random 
Forest to Modeling Structure-Activity Relationships of Pharmaceutical Molecules, 
MCS 2004, Roli, F. and Windeatt, T. (Eds.) pp. 334-343.
}
\seealso{
See \code{\link{rf.cv}} for the Cross-Validation of Classification and 
Regression models using Random Forest
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>
}
\keyword{rf.fs}
