% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BigVARObjectClass.R
\docType{methods}
\name{cv.BigVAR}
\alias{cv.BigVAR}
\alias{cv.BigVAR,BigVAR-method}
\title{Cross Validation for BigVAR}
\usage{
cv.BigVAR(object)
}
\arguments{
\item{object}{BigVAR object created from \code{ConstructModel}}
}
\value{
An object of class \code{BigVAR.results}.
}
\description{
Cross Validation for BigVAR
}
\details{
The main function of the BigVAR package. Performs cross validation to select penalty parameters over a training sample (as the minimizer of in-sample MSFE), then evaluates them over a test set.  Compares against sample mean, random walk, AIC, and BIC benchmarks.  Creates an object of class \code{BigVAR.results}
}
\examples{
data(Y)
# Fit a Basic VARX-L with rolling cross validation 
Model1=constructModel(Y,p=4,struct="Basic",gran=c(50,10))
results=cv.BigVAR(Model1)
}
\seealso{
\code{\link{constructModel}}, \code{\link{BigVAR.results}},\code{\link{BigVAR.est}}
}

