% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdgetDiagonal_hdf5}
\alias{bdgetDiagonal_hdf5}
\title{Get Matrix Diagonal from HDF5}
\usage{
bdgetDiagonal_hdf5(filename, group, dataset)
}
\arguments{
\item{filename}{Character string. Path to the HDF5 file.}

\item{group}{Character string. Path to the group containing the dataset.}

\item{dataset}{Character string. Name of the dataset.}
}
\value{
Numeric vector containing diagonal elements.
}
\description{
Retrieves the diagonal elements from a matrix stored in an HDF5 file.
}
\details{
This function provides efficient access to matrix diagonal elements with:
\itemize{
\item Access features:
\itemize{
\item Direct diagonal access
\item Memory-efficient retrieval
\item Support for large matrices
}
\item Implementation features:
\itemize{
\item Safe HDF5 file operations
\item Memory-efficient implementation
\item Comprehensive error handling
\item Read-only access to files
}
}

The function opens the HDF5 file in read-only mode to ensure data safety.
}
\examples{
\dontrun{
library(BigDataStatMeth)

# Create test matrix
X <- matrix(rnorm(100), 10, 10)
diag(X) <- 0.5

# Save to HDF5
bdCreate_hdf5_matrix("test.hdf5", X, "data", "matrix1",
                     overwriteFile = TRUE)

# Get diagonal
diag_elements <- bdgetDiagonal_hdf5("test.hdf5", "data", "matrix1")
print(diag_elements)

# Cleanup
if (file.exists("test.hdf5")) {
  file.remove("test.hdf5")
}
}

}
\references{
\itemize{
\item The HDF Group. (2000-2010). HDF5 User's Guide.
}
}
\seealso{
\itemize{
\item \code{\link{bdWriteDiagonal_hdf5}} for writing diagonal elements
\item \code{\link{bdCreate_hdf5_matrix}} for creating HDF5 matrices
}
}
