/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricMultivariateDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.GammaDistribution;
import dr.math.distributions.WishartDistribution;
import dr.math.distributions.WishartStatistics;

public class WishartGammalDistributionModel
extends AbstractModel
implements ParametricMultivariateDistributionModel,
WishartStatistics {
    private final int dim;
    private final Parameter df;
    private final Parameter mixing;
    private final Parameter scale;
    private final boolean randomMixing;
    private WishartDistribution wishart;
    private WishartDistribution storedWishart;
    private boolean wishartDistributionKnown;
    private boolean storedWishartDistributionKnown;
    public static final String TYPE = "WishartGamma";

    public WishartGammalDistributionModel(Parameter parameter, Parameter parameter2, Parameter parameter3, boolean bl) {
        super(TYPE);
        this.df = parameter;
        this.mixing = parameter2;
        this.scale = parameter3;
        this.addVariable(parameter);
        this.addVariable(parameter2);
        this.addVariable(parameter3);
        this.randomMixing = bl;
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter.getDimension()));
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter2.getDimension()));
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter3.getDimension()));
        this.dim = parameter2.getDimension();
        if (this.dim != parameter3.getDimension()) {
            throw new IllegalArgumentException();
        }
        this.wishartDistributionKnown = false;
    }

    @Override
    public double logPdf(double[] dArray) {
        if (dArray.length != this.dim * this.dim) {
            throw new IllegalArgumentException("Data of wrong dimension in " + this.getId());
        }
        if (!this.wishartDistributionKnown) {
            this.wishart = this.createNewWishartDistribution();
            this.wishartDistributionKnown = true;
        }
        double d = this.wishart.logPdf(dArray);
        if (this.randomMixing) {
            for (int i = 0; i < this.dim; ++i) {
                double d2 = this.mixing.getParameterValue(i);
                double d3 = this.scale.getParameterValue(i);
                d += GammaDistribution.logPdf(d2, 0.5, d3 * d3);
            }
        }
        return d;
    }

    @Override
    public double[][] getScaleMatrix() {
        double d = this.df.getParameterValue(0);
        double[][] dArray = new double[this.dim][this.dim];
        for (int i = 0; i < this.dim; ++i) {
            dArray[i][i] = 1.0 / (2.0 * d * this.mixing.getParameterValue(i));
        }
        return dArray;
    }

    @Override
    public double getDF() {
        return this.df.getParameterValue(0) + (double)this.dim - 1.0;
    }

    @Override
    public double[] getMean() {
        return new double[this.dim];
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.mixing || variable == this.df) {
            this.wishartDistributionKnown = false;
        }
        if (!this.randomMixing && variable == this.mixing) {
            throw new IllegalArgumentException("WishartGamma distribution is not configured for random mixing");
        }
    }

    @Override
    protected void storeState() {
        this.storedWishart = this.wishart;
        this.storedWishartDistributionKnown = this.wishartDistributionKnown;
    }

    @Override
    protected void restoreState() {
        this.wishartDistributionKnown = this.storedWishartDistributionKnown;
        this.wishart = this.storedWishart;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Variable<Double> getLocationVariable() {
        throw new UnsupportedOperationException("Not implemented");
    }

    private WishartDistribution createNewWishartDistribution() {
        return new WishartDistribution(this.getDF(), this.getScaleMatrix());
    }

    @Override
    public double[] nextRandom() {
        return null;
    }

    @Override
    public int getDimension() {
        return this.dim;
    }
}

