/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.geo.SpaceTime;
import dr.geo.SpaceTimeRejector;
import dr.math.distributions.MultivariateNormalDistribution;
import java.util.ArrayList;
import java.util.List;

public class SpaceTimeSimulator {
    MultivariateNormalDistribution D;

    public SpaceTimeSimulator(MultivariateNormalDistribution multivariateNormalDistribution) {
        this.D = multivariateNormalDistribution;
    }

    public List<SpaceTime> simulatePath(SpaceTime spaceTime, SpaceTimeRejector spaceTimeRejector, double d, int n) {
        ArrayList<SpaceTime> arrayList = new ArrayList<SpaceTime>();
        arrayList.add(spaceTime);
        for (int i = 0; i < n; ++i) {
            SpaceTime spaceTime2;
            SpaceTime spaceTime3 = arrayList.get(arrayList.size() - 1);
            do {
                double[] dArray = new double[spaceTime.getX().length];
                this.D.nextScaledMultivariateNormal(spaceTime3.getX(), d, dArray);
                spaceTime2 = new SpaceTime(spaceTime3.getTime() + d, dArray);
            } while (spaceTimeRejector.reject(spaceTime2.time, spaceTime2.space));
            arrayList.add(spaceTime2);
        }
        return arrayList;
    }

    public SpaceTime simulate(SpaceTime spaceTime, SpaceTimeRejector spaceTimeRejector, double d, int n) {
        SpaceTime spaceTime2 = new SpaceTime(spaceTime);
        SpaceTime spaceTime3 = new SpaceTime(spaceTime);
        for (int i = 0; i < n; ++i) {
            do {
                this.D.nextScaledMultivariateNormal(spaceTime3.getX(), d, spaceTime2.space);
                spaceTime2.time = spaceTime3.getTime() + d;
            } while (spaceTimeRejector.reject(spaceTime2.time, spaceTime2.space));
            spaceTime3.time = spaceTime2.time;
            spaceTime3.space = spaceTime2.space;
        }
        return spaceTime3;
    }

    public SpaceTime simulateAbsorbing(SpaceTime spaceTime, SpaceTimeRejector spaceTimeRejector, double d, int n) {
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        SpaceTime spaceTime2 = null;
        while (!bl) {
            SpaceTime spaceTime3 = new SpaceTime(spaceTime);
            spaceTime2 = new SpaceTime(spaceTime);
            while (n2 < n && !bl2) {
                this.D.nextScaledMultivariateNormal(spaceTime2.getX(), d, spaceTime3.space);
                spaceTime3.time = spaceTime2.getTime() + d;
                bl2 = spaceTimeRejector.reject(spaceTime3.time, spaceTime3.space);
                spaceTime2.time = spaceTime3.time;
                spaceTime2.space = spaceTime3.space;
                ++n2;
            }
            if (bl2) continue;
            bl = true;
        }
        return spaceTime2;
    }
}

