/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.Codons;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.Nucleotides;
import dr.evolution.datatype.TwoStates;
import dr.evolution.sequence.Sequence;
import dr.evolution.sequence.UncertainSequence;
import dr.evolution.util.Taxon;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.StringTokenizer;

public class SequenceParser
extends AbstractXMLObjectParser {
    public static final String SEQUENCE = "sequence";
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Taxon.class), new ElementRule(String.class, "A character string representing the aligned molecular sequence", "ACGACTAGCATCGAGCTTCG--GATAGCATGC")};

    @Override
    public String getParserName() {
        return SEQUENCE;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Object object;
        CharSequence charSequence;
        Taxon taxon = (Taxon)xMLObject.getChild(Taxon.class);
        DataType dataType = null;
        if (xMLObject.hasAttribute("dataType")) {
            charSequence = xMLObject.getStringAttribute("dataType");
            if (((String)charSequence).equals("nucleotide")) {
                dataType = Nucleotides.INSTANCE;
            } else if (((String)charSequence).equals("amino acid")) {
                dataType = AminoAcids.INSTANCE;
            } else if (((String)charSequence).equals("codon")) {
                dataType = Codons.UNIVERSAL;
            } else if (((String)charSequence).equals("binary")) {
                dataType = TwoStates.INSTANCE;
            }
        }
        charSequence = new StringBuffer();
        for (int i = 0; i < xMLObject.getChildCount(); ++i) {
            object = xMLObject.getChild(i);
            if (!(object instanceof String)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer((String)object);
            while (stringTokenizer.hasMoreTokens()) {
                ((StringBuffer)charSequence).append(stringTokenizer.nextToken());
            }
        }
        String string = ((StringBuffer)charSequence).toString();
        if (string.length() == 0) {
            throw new XMLParseException("Sequence data missing from sequence element!");
        }
        object = UncertainSequence.containsWeights(string) ? new UncertainSequence() : new Sequence();
        if (dataType != null) {
            ((Sequence)object).setDataType(dataType);
        }
        ((Sequence)object).setSequenceString(string);
        ((Sequence)object).setTaxon(taxon);
        return object;
    }

    @Override
    public String getParserDescription() {
        return "A biomolecular sequence.";
    }

    @Override
    public Class getReturnType() {
        return Sequence.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

