/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.evomodel.tree.TreeStatistic;
import java.util.Set;

public class ParsimonyStateStatistic
extends TreeStatistic {
    private Tree tree = null;
    private Set stateLeafSet = null;
    private Set<String> mrcaLeafSet = null;

    public ParsimonyStateStatistic(String string, Tree tree, TaxonList taxonList, TaxonList taxonList2) throws TreeUtils.MissingTaxonException {
        super(string);
        this.tree = tree;
        this.stateLeafSet = TreeUtils.getLeavesForTaxa(tree, taxonList);
        if (taxonList2 != null) {
            this.mrcaLeafSet = TreeUtils.getLeavesForTaxa(tree, taxonList2);
        }
    }

    @Override
    public void setTree(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        NodeRef nodeRef = this.mrcaLeafSet != null ? TreeUtils.getCommonAncestorNode(this.tree, this.mrcaLeafSet) : this.tree.getRoot();
        return TreeUtils.getParsimonyState(this.tree, nodeRef, this.stateLeafSet);
    }
}

