/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.speciation;

import dr.evolution.tree.TreeUtils;
import dr.evomodel.speciation.SpeciationLikelihood;
import dr.evomodel.tree.TMRCAStatistic;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.GradientProvider;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import dr.math.distributions.Distribution;
import dr.util.Citable;
import dr.util.Citation;
import java.util.ArrayList;
import java.util.List;

public class CalibratedSpeciationLikelihood
extends AbstractModelLikelihood
implements Citable {
    private final SpeciationLikelihood speciationLikelihood;
    private final TreeModel tree;
    private final List<CalibrationLikelihood> calibrationLikelihoods;

    public CalibratedSpeciationLikelihood(String string, SpeciationLikelihood speciationLikelihood, TreeModel treeModel, List<CalibrationLikelihood> list) {
        super(string);
        this.speciationLikelihood = speciationLikelihood;
        this.tree = treeModel;
        this.calibrationLikelihoods = list;
        this.addModel(speciationLikelihood);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        double d = this.speciationLikelihood.getLogLikelihood();
        for (CalibrationLikelihood calibrationLikelihood : this.calibrationLikelihoods) {
            d += calibrationLikelihood.getLogLikelihood();
        }
        return d;
    }

    public List<CalibrationLikelihood> getCalibrationLikelihoods() {
        return this.calibrationLikelihoods;
    }

    @Override
    public void makeDirty() {
        this.speciationLikelihood.makeDirty();
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.PRIOR_MODELS;
    }

    @Override
    public String getDescription() {
        return "Calibration prior distributions";
    }

    @Override
    public List<Citation> getCitations() {
        ArrayList<Citation> arrayList = new ArrayList<Citation>();
        for (CalibrationLikelihood calibrationLikelihood : this.calibrationLikelihoods) {
            Citation citation;
            if (!(calibrationLikelihood.getDistribution() instanceof Citable) || arrayList.contains(citation = ((Citable)((Object)calibrationLikelihood.getDistribution())).getCitations().get(0))) continue;
            arrayList.add(((Citable)((Object)calibrationLikelihood.getDistribution())).getCitations().get(0));
        }
        return arrayList;
    }

    public static class CalibrationLikelihood {
        private final TMRCAStatistic tmrcaStatistic;
        private final Distribution distribution;

        public CalibrationLikelihood(TMRCAStatistic tMRCAStatistic, Distribution distribution) {
            this.tmrcaStatistic = tMRCAStatistic;
            this.distribution = distribution;
        }

        public int getMrcaNodeNumber() {
            return TreeUtils.getCommonAncestorNode(this.tmrcaStatistic.getTree(), this.tmrcaStatistic.getLeafSet()).getNumber();
        }

        public Distribution getDistribution() {
            return this.distribution;
        }

        public double getLogLikelihood() {
            double d = this.getNodeHeight();
            return this.distribution.logPdf(d);
        }

        private final double getNodeHeight() {
            return this.tmrcaStatistic.getStatisticValue(0);
        }

        public double[] getGradientLogDensity() {
            return ((GradientProvider)((Object)this.distribution)).getGradientLogDensity(this.getNodeHeight());
        }
    }
}

