/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.app.util.Arguments;
import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.continuous.AbstractMultivariateTraitLikelihood;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.tree.TreeStatistic;
import dr.evomodel.treelikelihood.MarkovJumpsBeagleTreeLikelihood;
import dr.geo.KMLCoordinates;
import dr.geo.Polygon2D;
import dr.geo.contouring.ContourWithSynder;
import dr.geo.math.SphericalPolarCoordinates;
import dr.inference.model.Statistic;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.stats.DiscreteStatistics;
import dr.stats.Regression;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.math.stat.ranking.NaturalRanking;
import org.jdom.Element;

public class ContinuousDiffusionStatistic
extends Statistic.Abstract {
    public static final String CONTINUOUS_DIFFUSION_STATISTIC = "continuousDiffusionStatistic";
    public static final String DIFFUSION_RATE_STATISTIC = "diffusionRateStatistic";
    public static final String TREE_DISPERSION_STATISTIC = "treeDispersionStatistic";
    public static final String USE_GREATCIRCLEDISTANCES = "greatCircleDistance";
    public static final String MODE = "mode";
    public static final String MEDIAN = "median";
    public static final String AVERAGE = "average";
    public static final String WEIGHTED_AVERAGE = "weightedAverage";
    public static final String COEFFICIENT_OF_VARIATION = "coefficientOfVariation";
    public static final String SPEARMAN = "spearman";
    public static final String CORRELATION_COEFFICIENT = "correlationCoefficient";
    public static final String DISTANCE_TIME_CORRELATION = "distanceTimeCorrelation";
    public static final String SQUAREDDISTANCE_TIME4_CORRELATION = "squaredDistanceTimeFourCorrelation";
    public static final String R_SQUARED = "Rsquared";
    public static final String STATISTIC = "statistic";
    public static final String TRAIT = "trait";
    public static final String TRAIT2DAREA = "trait2Darea";
    public static final String DIMENSION = "dimension";
    public static final String DIFFUSION_TIME = "diffusionTime";
    public static final String DIFFUSION_DISTANCE = "diffusionDistance";
    public static final String DIFFUSION_RATE = "diffusionRate";
    public static final String WAVEFRONT_DISTANCE = "wavefrontDistance";
    public static final String WAVEFRONT_DISTANCE_PHYLO = "wavefrontDistancePhylo";
    public static final String WAVEFRONT_RATE = "wavefrontRate";
    public static final String DIFFUSION_COEFFICIENT = "diffusionCoefficient";
    public static final String HEIGHT_UPPER = "heightUpper";
    public static final String HEIGHT_LOWER = "heightLower";
    public static final String HEIGHT_LOWER_SERIE = "heightLowerSerie";
    public static final String CUMULATIVE = "cumulative";
    public static final String DISCRETE_STATE = "discreteState";
    public static final Integer SITE = 0;
    public static final Integer NUMBER_OF_HISTORY_ENTRIES = 3;
    public static final String NOISE = "noise";
    public static final String TAXA = "taxa";
    public static final String BRANCHSET = "branchSet";
    public static final String ALL = "all";
    public static final String CLADE = "clade";
    public static final String BACKBONE = "backbone";
    public static final String BACKBONE_TIME = "backboneTime";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("name", true), AttributeRule.newBooleanRule("greatCircleDistance", true), AttributeRule.newStringRule("mode", true), AttributeRule.newStringRule("statistic", true), AttributeRule.newStringRule("discreteState", true), AttributeRule.newDoubleRule("heightUpper", true), AttributeRule.newDoubleRule("heightLower", true), AttributeRule.newStringRule("heightLowerSerie", true), AttributeRule.newDoubleRule("dimension", true), AttributeRule.newBooleanRule("cumulative", true), AttributeRule.newBooleanRule("noise", true), AttributeRule.newStringRule("branchSet", true), new ElementRule(TaxonList.class, true), new ElementRule(AbstractMultivariateTraitLikelihood.class, 1, Integer.MAX_VALUE), new ElementRule(MarkovJumpsBeagleTreeLikelihood.class, true)};

        @Override
        public String getParserName() {
            return ContinuousDiffusionStatistic.CONTINUOUS_DIFFUSION_STATISTIC;
        }

        @Override
        public String[] getParserNames() {
            return new String[]{this.getParserName(), ContinuousDiffusionStatistic.DIFFUSION_RATE_STATISTIC, ContinuousDiffusionStatistic.TREE_DISPERSION_STATISTIC};
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            int n;
            BranchSet branchSet;
            String string;
            summaryStatistic summaryStatistic2;
            Mode mode;
            String string2 = xMLObject.getAttribute("name", xMLObject.getId());
            boolean bl = xMLObject.getAttribute(ContinuousDiffusionStatistic.USE_GREATCIRCLEDISTANCES, false);
            String string3 = xMLObject.getAttribute(ContinuousDiffusionStatistic.MODE, ContinuousDiffusionStatistic.WEIGHTED_AVERAGE);
            if (string3.equals(ContinuousDiffusionStatistic.AVERAGE)) {
                mode = Mode.AVERAGE;
            } else if (string3.equals(ContinuousDiffusionStatistic.MEDIAN)) {
                mode = Mode.MEDIAN;
            } else if (string3.equals(ContinuousDiffusionStatistic.COEFFICIENT_OF_VARIATION)) {
                mode = Mode.COEFFICIENT_OF_VARIATION;
            } else if (string3.equals(ContinuousDiffusionStatistic.WEIGHTED_AVERAGE)) {
                mode = Mode.WEIGHTED_AVERAGE;
            } else if (string3.equals(ContinuousDiffusionStatistic.SPEARMAN)) {
                mode = Mode.SPEARMAN;
            } else if (string3.equals(ContinuousDiffusionStatistic.CORRELATION_COEFFICIENT)) {
                mode = Mode.CORRELATION_COEFFICIENT;
            } else if (string3.equals(ContinuousDiffusionStatistic.R_SQUARED)) {
                mode = Mode.R_SQUARED;
            } else {
                System.err.println("Unknown mode: " + string3 + ". Reverting to weighted average for " + string2);
                mode = Mode.WEIGHTED_AVERAGE;
            }
            double d = xMLObject.getAttribute(ContinuousDiffusionStatistic.HEIGHT_UPPER, Double.MAX_VALUE);
            double d2 = xMLObject.getAttribute(ContinuousDiffusionStatistic.HEIGHT_LOWER, 0.0);
            double[] dArray = null;
            if (xMLObject.hasAttribute(ContinuousDiffusionStatistic.HEIGHT_LOWER_SERIE)) {
                String string4 = xMLObject.getStringAttribute(ContinuousDiffusionStatistic.HEIGHT_LOWER_SERIE);
                try {
                    dArray = ContinuousDiffusionStatistic.parseVariableLengthDoubleArray(string4);
                }
                catch (Arguments.ArgumentException argumentException) {
                    System.err.println(string2 + ": error reading " + ContinuousDiffusionStatistic.HEIGHT_LOWER_SERIE);
                    System.exit(1);
                }
            }
            boolean bl2 = xMLObject.getAttribute(ContinuousDiffusionStatistic.CUMULATIVE, false);
            boolean bl3 = xMLObject.getAttribute(ContinuousDiffusionStatistic.NOISE, false);
            String string5 = xMLObject.getAttribute(ContinuousDiffusionStatistic.STATISTIC, ContinuousDiffusionStatistic.DIFFUSION_RATE);
            int n2 = 1;
            if (string5.equals(ContinuousDiffusionStatistic.DIFFUSION_RATE)) {
                summaryStatistic2 = summaryStatistic.DIFFUSION_RATE;
                if (string3.equals(ContinuousDiffusionStatistic.SPEARMAN) || string3.equals(ContinuousDiffusionStatistic.R_SQUARED) || string3.equals(ContinuousDiffusionStatistic.CORRELATION_COEFFICIENT)) {
                    System.err.println(string2 + ": mode = " + string3 + " ignored for " + ContinuousDiffusionStatistic.DIFFUSION_TIME + ", reverting to weighted average mode");
                    mode = Mode.WEIGHTED_AVERAGE;
                }
            } else if (string5.equals(ContinuousDiffusionStatistic.DIFFUSION_TIME)) {
                summaryStatistic2 = summaryStatistic.DIFFUSION_TIME;
                if (!string3.equals(ContinuousDiffusionStatistic.WEIGHTED_AVERAGE)) {
                    System.err.println(string2 + ": mode = " + string3 + " ignored for " + ContinuousDiffusionStatistic.DIFFUSION_TIME);
                }
            } else if (string5.equals(ContinuousDiffusionStatistic.DIFFUSION_DISTANCE)) {
                summaryStatistic2 = summaryStatistic.DIFFUSION_DISTANCE;
                if (!string3.equals(ContinuousDiffusionStatistic.WEIGHTED_AVERAGE)) {
                    System.err.println(string2 + ": mode = " + string3 + " ignored for " + ContinuousDiffusionStatistic.DIFFUSION_DISTANCE);
                }
            } else if (string5.equals(ContinuousDiffusionStatistic.DISTANCE_TIME_CORRELATION)) {
                summaryStatistic2 = summaryStatistic.DISTANCE_TIME_CORRELATION;
                if (string3.equals(ContinuousDiffusionStatistic.AVERAGE) || string3.equals(ContinuousDiffusionStatistic.WEIGHTED_AVERAGE) || string3.equals(ContinuousDiffusionStatistic.COEFFICIENT_OF_VARIATION) || string3.equals(ContinuousDiffusionStatistic.MEDIAN)) {
                    System.err.println(string2 + ": mode = " + string3 + " ignored for " + ContinuousDiffusionStatistic.DISTANCE_TIME_CORRELATION + ", reverting to correlation coefficient mode");
                    mode = Mode.CORRELATION_COEFFICIENT;
                }
            } else if (string5.equals(ContinuousDiffusionStatistic.SQUAREDDISTANCE_TIME4_CORRELATION)) {
                summaryStatistic2 = summaryStatistic.SQUAREDDISTANCE_TIME4_CORRELATION;
                if (string3.equals(ContinuousDiffusionStatistic.AVERAGE) || string3.equals(ContinuousDiffusionStatistic.WEIGHTED_AVERAGE) || string3.equals(ContinuousDiffusionStatistic.COEFFICIENT_OF_VARIATION) || string3.equals(ContinuousDiffusionStatistic.MEDIAN)) {
                    System.err.println(string2 + ": mode = " + string3 + " ignored for " + ContinuousDiffusionStatistic.SQUAREDDISTANCE_TIME4_CORRELATION + ", reverting to correlation coefficient mode");
                    mode = Mode.CORRELATION_COEFFICIENT;
                }
            } else if (string5.equals(ContinuousDiffusionStatistic.WAVEFRONT_DISTANCE)) {
                summaryStatistic2 = summaryStatistic.WAVEFRONT_DISTANCE;
                if (!string3.equals(ContinuousDiffusionStatistic.WEIGHTED_AVERAGE)) {
                    System.err.println(string2 + ": mode = " + string3 + " ignored for " + ContinuousDiffusionStatistic.WAVEFRONT_DISTANCE);
                }
            } else if (string5.equals(ContinuousDiffusionStatistic.WAVEFRONT_DISTANCE_PHYLO)) {
                summaryStatistic2 = summaryStatistic.WAVEFRONT_DISTANCE_PHYLO;
                if (!string3.equals(ContinuousDiffusionStatistic.WEIGHTED_AVERAGE)) {
                    System.err.println(string2 + ": mode = " + string3 + " ignored for " + ContinuousDiffusionStatistic.WAVEFRONT_DISTANCE);
                }
            } else if (string5.equals(ContinuousDiffusionStatistic.TRAIT)) {
                summaryStatistic2 = summaryStatistic.TRAIT;
                if (string3.equals(ContinuousDiffusionStatistic.WEIGHTED_AVERAGE)) {
                    System.err.println(string2 + ": mode = " + string3 + " ignored for " + ContinuousDiffusionStatistic.TRAIT + ", resorting to " + ContinuousDiffusionStatistic.AVERAGE);
                    mode = Mode.AVERAGE;
                }
                if (d < Double.MAX_VALUE) {
                    System.err.println(string2 + ": only " + ContinuousDiffusionStatistic.HEIGHT_LOWER + " or " + ContinuousDiffusionStatistic.HEIGHT_LOWER_SERIE + " are relevant for " + ContinuousDiffusionStatistic.TRAIT);
                }
                if ((n2 = xMLObject.getAttribute(ContinuousDiffusionStatistic.DIMENSION, 1).intValue()) == 0) {
                    System.err.println(string2 + ": trait dimensions start from 1. Setting dimension to 1");
                    n2 = 1;
                }
                if (bl2) {
                    System.err.println(string2 + ": " + ContinuousDiffusionStatistic.CUMULATIVE + " is ignored for " + ContinuousDiffusionStatistic.TRAIT);
                }
                if (bl) {
                    System.err.println(string2 + ": " + ContinuousDiffusionStatistic.USE_GREATCIRCLEDISTANCES + " is ignored for " + ContinuousDiffusionStatistic.TRAIT);
                }
            } else if (string5.equals(ContinuousDiffusionStatistic.TRAIT2DAREA)) {
                summaryStatistic2 = summaryStatistic.TRAIT2DAREA;
                n2 = xMLObject.getAttribute(ContinuousDiffusionStatistic.DIMENSION, 2);
                if (n2 != 2) {
                    System.err.println(string2 + ": trait dimension (" + n2 + ") is not 2. Cannot calculate 2D area for the traits, 0's will be returned");
                }
            } else if (string5.equals(ContinuousDiffusionStatistic.WAVEFRONT_RATE)) {
                summaryStatistic2 = summaryStatistic.WAVEFRONT_RATE;
            } else if (string5.equals(ContinuousDiffusionStatistic.DIFFUSION_COEFFICIENT)) {
                summaryStatistic2 = summaryStatistic.DIFFUSION_COEFFICIENT;
            } else if (string5.equals(ContinuousDiffusionStatistic.DISTANCE_TIME_CORRELATION)) {
                summaryStatistic2 = summaryStatistic.DISTANCE_TIME_CORRELATION;
            } else if (string5.equals(ContinuousDiffusionStatistic.SQUAREDDISTANCE_TIME4_CORRELATION)) {
                summaryStatistic2 = summaryStatistic.SQUAREDDISTANCE_TIME4_CORRELATION;
            } else {
                System.err.println(string2 + ": unknown statistic: " + string5 + ". Reverting to diffusion rate.");
                summaryStatistic2 = summaryStatistic.DIFFUSION_RATE;
            }
            if ((string = xMLObject.getAttribute(ContinuousDiffusionStatistic.BRANCHSET, ContinuousDiffusionStatistic.ALL)).equals(ContinuousDiffusionStatistic.CLADE)) {
                branchSet = BranchSet.CLADE;
            } else if (string.equals(ContinuousDiffusionStatistic.BACKBONE)) {
                branchSet = BranchSet.BACKBONE;
            } else if (string.equals(ContinuousDiffusionStatistic.ALL)) {
                branchSet = BranchSet.ALL;
            } else {
                System.err.println(string2 + ": unknown branchset: " + string + ". Reverting to all branches.");
                branchSet = BranchSet.ALL;
            }
            TaxonList taxonList = null;
            double d3 = 0.0;
            if (branchSet.equals((Object)BranchSet.CLADE)) {
                taxonList = (TaxonList)xMLObject.getChild(TaxonList.class);
                if (taxonList == null) {
                    System.err.println("empty taxon list in continuousDiffusionStatistic despite 'clade' branchSet attribute");
                }
            } else if (branchSet.equals((Object)BranchSet.BACKBONE)) {
                taxonList = (TaxonList)xMLObject.getChild(TaxonList.class);
                if (xMLObject.hasAttribute(ContinuousDiffusionStatistic.BACKBONE_TIME)) {
                    d3 = xMLObject.getAttribute(ContinuousDiffusionStatistic.BACKBONE_TIME, 0.0);
                    if (taxonList != null) {
                        System.err.println("both backbone time and taxon list provided for backbone definition in continuousDiffusionStatistic. Ignoring taxon list...");
                    }
                } else if (taxonList == null) {
                    System.err.println("empty taxon list and no backboneTime in continuousDiffusionStatistic despite 'backbone' branchSet attribute. Ignoring 'backbone' branchSet...");
                }
            } else if (branchSet.equals((Object)BranchSet.ALL)) {
                taxonList = (TaxonList)xMLObject.getChild(TaxonList.class);
                if (taxonList != null) {
                    System.err.println("taxon list provided in continuousDiffusionStatistic but no 'clade' or 'backbone' branchSet attribute?? Ignoring taxon list...");
                }
                if (xMLObject.hasAttribute(ContinuousDiffusionStatistic.BACKBONE_TIME)) {
                    System.err.println("backoneTime provided in continuousDiffusionStatistic but no 'backbone' branchSet attribute?? Ignoring backboneTime list...");
                }
            }
            String string6 = null;
            if (xMLObject.hasAttribute(ContinuousDiffusionStatistic.DISCRETE_STATE)) {
                string6 = xMLObject.getStringAttribute(ContinuousDiffusionStatistic.DISCRETE_STATE);
            }
            ArrayList<AbstractMultivariateTraitLikelihood> arrayList = new ArrayList<AbstractMultivariateTraitLikelihood>();
            MarkovJumpsBeagleTreeLikelihood markovJumpsBeagleTreeLikelihood = null;
            for (n = 0; n < xMLObject.getChildCount(); ++n) {
                if (xMLObject.getChild(n) instanceof AbstractMultivariateTraitLikelihood) {
                    AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood = (AbstractMultivariateTraitLikelihood)xMLObject.getChild(n);
                    arrayList.add(abstractMultivariateTraitLikelihood);
                }
                if (!(xMLObject.getChild(n) instanceof MarkovJumpsBeagleTreeLikelihood)) continue;
                markovJumpsBeagleTreeLikelihood = (MarkovJumpsBeagleTreeLikelihood)xMLObject.getChild(n);
            }
            if (string6 == null && markovJumpsBeagleTreeLikelihood != null) {
                System.err.println(string2 + ": markovJumpsTreeLikelihood specified for state-specific summaries but no state string.. ignoring markovJumpsTreeLikelihood");
                markovJumpsBeagleTreeLikelihood = null;
            } else if (string6 != null && markovJumpsBeagleTreeLikelihood == null) {
                System.err.println(string2 + ": state number provided for state-specific summaries but no markovJumpsTreeLikelihood specified.. ignoring state");
                string6 = null;
            } else if (string6 != null && markovJumpsBeagleTreeLikelihood != null) {
                if (string5.equals(ContinuousDiffusionStatistic.TRAIT)) {
                    System.err.println(string2 + ": ignoring state-specific summary (for " + string6 + ") for " + ContinuousDiffusionStatistic.TRAIT + ", resorting to overall summary");
                } else {
                    n = -1;
                    int n3 = 0;
                    try {
                        while (n < 0) {
                            if (string6.equalsIgnoreCase(markovJumpsBeagleTreeLikelihood.formattedState(new int[]{n3}).replaceAll("\"", ""))) {
                                n = n3;
                                System.out.println(string2 + ": summarizing continuous diffusion statistic for state " + markovJumpsBeagleTreeLikelihood.formattedState(new int[]{n3}));
                            }
                            ++n3;
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        int[] nArray = new int[n3];
                        for (int i = 0; i < nArray.length; ++i) {
                            nArray[i] = i;
                        }
                        System.err.println(string2 + ": state " + string6 + " not found among " + markovJumpsBeagleTreeLikelihood.formattedState(nArray) + "... ignoring state");
                        markovJumpsBeagleTreeLikelihood = null;
                        string6 = null;
                    }
                }
            }
            return new ContinuousDiffusionStatistic(string2, arrayList, bl, mode, summaryStatistic2, d, d2, dArray, bl2, bl3, n2, taxonList, branchSet, d3, string6, markovJumpsBeagleTreeLikelihood);
        }

        @Override
        public String getParserDescription() {
            return "A statistic that returns the average of the branch diffusion rates";
        }

        @Override
        public Class getReturnType() {
            return TreeStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private boolean useGreatCircleDistances;
    private List<AbstractMultivariateTraitLikelihood> traitLikelihoods;
    private MarkovJumpsBeagleTreeLikelihood markovJumpLikelihood;
    private String stateString;
    private Mode summaryMode;
    private summaryStatistic summaryStat;
    private double heightUpper;
    private double[] heightLowers;
    private boolean cumulative;
    private boolean trueNoise;
    private int dimension;
    private TaxonList taxonList;
    private BranchSet branchset;
    private double backboneTime;

    public ContinuousDiffusionStatistic(String string, List<AbstractMultivariateTraitLikelihood> list, boolean bl, Mode mode, summaryStatistic summaryStatistic2, double d, double d2, double[] dArray, boolean bl2, boolean bl3, int n, TaxonList taxonList, BranchSet branchSet, Double d3, String string2, MarkovJumpsBeagleTreeLikelihood markovJumpsBeagleTreeLikelihood) {
        super(string);
        this.traitLikelihoods = list;
        this.useGreatCircleDistances = bl;
        this.summaryMode = mode;
        this.summaryStat = summaryStatistic2;
        this.heightUpper = d;
        if (dArray == null) {
            this.heightLowers = new double[]{d2};
        } else {
            this.heightLowers = ContinuousDiffusionStatistic.extractUnique(dArray);
            Arrays.sort(this.heightLowers);
            ContinuousDiffusionStatistic.reverse(this.heightLowers);
        }
        this.cumulative = bl2;
        this.trueNoise = bl3;
        this.dimension = n;
        this.taxonList = taxonList;
        this.branchset = branchSet;
        this.backboneTime = d3;
        this.stateString = string2;
        this.markovJumpLikelihood = markovJumpsBeagleTreeLikelihood;
    }

    @Override
    public int getDimension() {
        return this.heightLowers.length;
    }

    @Override
    public double getStatisticValue(int n) {
        Object object;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        ArrayList<Double> arrayList4 = new ArrayList<Double>();
        ArrayList<double[]> arrayList5 = new ArrayList<double[]>();
        ArrayList<Double> arrayList6 = new ArrayList<Double>();
        double d8 = 0.0;
        double d9 = this.heightLowers[n];
        double d10 = Double.MAX_VALUE;
        if (this.heightLowers.length == 1) {
            d10 = this.heightUpper;
        } else if (n > 0 && !this.cumulative) {
            d10 = this.heightLowers[n - 1];
        }
        for (AbstractMultivariateTraitLikelihood object2 : this.traitLikelihoods) {
            MutableTreeModel mutableTreeModel = object2.getTreeModel();
            BranchRateModel branchRateModel = object2.getBranchRateModel();
            String string = object2.getTraitName();
            for (int i = 0; i < mutableTreeModel.getNodeCount(); ++i) {
                double[] dArray;
                double d11;
                double d12;
                double[] dArray2;
                NodeRef nodeRef = mutableTreeModel.getNode(i);
                if (nodeRef == mutableTreeModel.getRoot()) continue;
                NodeRef nodeRef2 = mutableTreeModel.getParent(nodeRef);
                boolean bl = true;
                if (this.branchset.equals((Object)BranchSet.CLADE)) {
                    try {
                        bl = this.inClade(mutableTreeModel, nodeRef, this.taxonList);
                    }
                    catch (TreeUtils.MissingTaxonException missingTaxonException) {
                        throw new RuntimeException(missingTaxonException.toString());
                    }
                }
                if (this.branchset.equals((Object)BranchSet.BACKBONE)) {
                    if (this.backboneTime > 0.0) {
                        bl = ContinuousDiffusionStatistic.onAncestralPathTime(mutableTreeModel, nodeRef, this.backboneTime);
                    } else {
                        try {
                            bl = ContinuousDiffusionStatistic.onAncestralPathTaxa(mutableTreeModel, nodeRef, this.taxonList);
                        }
                        catch (TreeUtils.MissingTaxonException missingTaxonException) {
                            throw new RuntimeException(missingTaxonException.toString());
                        }
                    }
                }
                if (!bl || !(mutableTreeModel.getNodeHeight(nodeRef2) > d9) || !(mutableTreeModel.getNodeHeight(nodeRef) < d10)) continue;
                double[] missingTaxonException = object2.getTraitForNode(mutableTreeModel, nodeRef, string);
                double[] dArray3 = dArray2 = object2.getTraitForNode(mutableTreeModel, nodeRef2, string);
                double[] dArray4 = missingTaxonException;
                double d13 = mutableTreeModel.getNodeHeight(nodeRef2);
                double d14 = mutableTreeModel.getNodeHeight(nodeRef);
                double d15 = branchRateModel != null ? branchRateModel.getBranchRate(mutableTreeModel, nodeRef) : 1.0;
                MultivariateDiffusionModel multivariateDiffusionModel = object2.diffusionModel;
                double[] dArray5 = multivariateDiffusionModel.getPrecisionParameter().getParameterValues();
                History history = null;
                if (this.stateString != null) {
                    history = this.setUpHistory(this.markovJumpLikelihood.getHistoryForNode(mutableTreeModel, nodeRef, SITE), this.markovJumpLikelihood.getStatesForNode(mutableTreeModel, nodeRef)[SITE], this.markovJumpLikelihood.getStatesForNode(mutableTreeModel, nodeRef2)[SITE], d14, d13);
                }
                if (mutableTreeModel.getNodeHeight(nodeRef2) > d10) {
                    d13 = d10;
                    dArray3 = this.imputeValue(missingTaxonException, dArray2, d10, mutableTreeModel.getNodeHeight(nodeRef), mutableTreeModel.getNodeHeight(nodeRef2), dArray5, d15, this.trueNoise);
                    if (this.stateString != null) {
                        history.truncateUpper(d13);
                    }
                }
                if (mutableTreeModel.getNodeHeight(nodeRef) < d9) {
                    d14 = d9;
                    dArray4 = this.imputeValue(missingTaxonException, dArray2, d9, mutableTreeModel.getNodeHeight(nodeRef), mutableTreeModel.getNodeHeight(nodeRef2), dArray5, d15, this.trueNoise);
                    if (this.stateString != null) {
                        history.truncateLower(d14);
                    }
                }
                if (this.dimension > dArray4.length) {
                    System.err.println("specified trait dimension for continuous trait summary, " + this.dimension + ", is > dimensionality of trait, " + dArray4.length + ". No trait summarized.");
                } else {
                    arrayList4.add(dArray4[this.dimension - 1]);
                }
                if (dArray4.length == 2) {
                    arrayList5.add(dArray4);
                }
                double d16 = this.stateString != null ? (!history.returnMismatch() ? history.getStateTime(this.stateString) : Double.NaN) : d13 - d14;
                d += d16;
                arrayList3.add(d16);
                if (this.stateString != null) {
                    history.setTraitsforHeights(dArray3, dArray4, dArray5, d15, this.trueNoise);
                }
                double[] dArray6 = object2.getTraitForNode(mutableTreeModel, mutableTreeModel.getRoot(), string);
                double d17 = mutableTreeModel.getNodeHeight(mutableTreeModel.getRoot()) - d14;
                if (this.useGreatCircleDistances && missingTaxonException.length == 2) {
                    double[] dArray7;
                    SphericalPolarCoordinates d112;
                    double d18;
                    d12 = this.stateString != null ? (!history.returnMismatch() ? history.getStateGreatCircleDistance(this.stateString) : Double.NaN) : ContinuousDiffusionStatistic.getGreatCircleDistance(dArray4, dArray3);
                    arrayList2.add(d12);
                    if (d16 > 0.0) {
                        d2 += d12;
                        double d20 = Math.pow(d12, 2.0) / (4.0 * d16);
                        arrayList6.add(d20);
                        d8 += d20 * d16;
                        arrayList.add(d12 / d16);
                    }
                    if (!((d18 = (d112 = new SphericalPolarCoordinates(dArray6[0], dArray6[1])).distance(new SphericalPolarCoordinates(dArray3[0], dArray3[1]))) > d3)) continue;
                    d3 = d18;
                    if (this.stateString != null) {
                        dArray7 = this.getStateTimeAndDistanceFromRoot(mutableTreeModel, nodeRef, d14, object2, string, dArray4, dArray5, branchRateModel, true);
                        if (dArray7[0] > 0.0) {
                            if (!history.returnMismatch()) {
                                d4 = d18 * (dArray7[0] / d17);
                                d6 = d4 / dArray7[0];
                                d5 = dArray7[1];
                                d7 = dArray7[1] / dArray7[0];
                            } else {
                                d4 = Double.NaN;
                                d6 = Double.NaN;
                                d5 = Double.NaN;
                                d7 = Double.NaN;
                            }
                        }
                    } else {
                        d4 = d18;
                        d6 = d18 / d17;
                        dArray7 = this.getTimeAndDistanceFromRoot(mutableTreeModel, nodeRef, d14, object2, string, dArray4, true);
                        d5 = dArray7[1];
                        d7 = dArray7[1] / dArray7[0];
                    }
                    if (d13 != d10 || !(d16 > 0.0)) continue;
                    d4 = d12;
                    d6 = d12 / d16;
                    d5 = d12;
                    d7 = d12 / d16;
                    continue;
                }
                d12 = this.stateString != null ? (!history.returnMismatch() ? history.getStateNativeDistance(this.stateString) : Double.NaN) : this.getNativeDistance(dArray4, dArray3);
                arrayList2.add(d12);
                if (d16 > 0.0) {
                    d2 += d12;
                    double d19 = Math.pow(d12, 2.0) / (4.0 * d16);
                    arrayList6.add(d19);
                    d8 += d19 * d16;
                    arrayList.add(d12 / d16);
                }
                if (!((d11 = this.getNativeDistance(dArray4, dArray6)) > d3)) continue;
                d3 = d11;
                if (this.stateString != null) {
                    dArray = this.getStateTimeAndDistanceFromRoot(mutableTreeModel, nodeRef, d14, object2, string, dArray4, dArray5, branchRateModel, false);
                    if (dArray[0] > 0.0) {
                        if (!history.returnMismatch()) {
                            d4 = d11 * (dArray[0] / d17);
                            d6 = d4 / dArray[0];
                            d5 = dArray[1];
                            d7 = dArray[1] / dArray[0];
                        } else {
                            d4 = Double.NaN;
                            d6 = Double.NaN;
                            d5 = Double.NaN;
                            d7 = Double.NaN;
                        }
                    }
                } else {
                    d4 = d11;
                    d6 = d11 / d17;
                    dArray = this.getTimeAndDistanceFromRoot(mutableTreeModel, nodeRef, d14, object2, string, dArray4, false);
                    d5 = dArray[1];
                    d7 = dArray[1] / dArray[0];
                }
                if (d13 != d10 || !(d16 > 0.0)) continue;
                d4 = d12;
                d6 = d12 / d16;
                d5 = d12;
                d7 = d12 / d16;
            }
        }
        if (this.summaryStat == summaryStatistic.DIFFUSION_RATE) {
            if (this.summaryMode == Mode.AVERAGE) {
                return DiscreteStatistics.mean(this.toArray(arrayList));
            }
            if (this.summaryMode == Mode.MEDIAN) {
                return DiscreteStatistics.median(this.toArray(arrayList));
            }
            if (this.summaryMode == Mode.COEFFICIENT_OF_VARIATION) {
                double d21 = DiscreteStatistics.mean(this.toArray(arrayList));
                return Math.sqrt(DiscreteStatistics.variance(this.toArray(arrayList), d21)) / d21;
            }
            return d2 / d;
        }
        if (this.summaryStat == summaryStatistic.TRAIT) {
            if (this.summaryMode == Mode.MEDIAN) {
                return DiscreteStatistics.median(this.toArray(arrayList4));
            }
            if (this.summaryMode == Mode.COEFFICIENT_OF_VARIATION) {
                double d22 = DiscreteStatistics.mean(this.toArray(arrayList4));
                return Math.sqrt(DiscreteStatistics.variance(this.toArray(arrayList4), d22)) / d22;
            }
            return DiscreteStatistics.mean(this.toArray(arrayList4));
        }
        if (this.summaryStat == summaryStatistic.TRAIT2DAREA) {
            double d23 = ContinuousDiffusionStatistic.getAreaFrom2Dtraits(arrayList5, 0.99);
            return d23;
        }
        if (this.summaryStat == summaryStatistic.DIFFUSION_COEFFICIENT) {
            if (this.summaryMode == Mode.AVERAGE) {
                return DiscreteStatistics.mean(this.toArray(arrayList6));
            }
            if (this.summaryMode == Mode.MEDIAN) {
                return DiscreteStatistics.median(this.toArray(arrayList6));
            }
            if (this.summaryMode == Mode.COEFFICIENT_OF_VARIATION) {
                double d24 = DiscreteStatistics.mean(this.toArray(arrayList6));
                return Math.sqrt(DiscreteStatistics.variance(this.toArray(arrayList6), d24)) / d24;
            }
            return d8 / d;
        }
        if (this.summaryStat == summaryStatistic.WAVEFRONT_DISTANCE) {
            return d4;
        }
        if (this.summaryStat == summaryStatistic.WAVEFRONT_DISTANCE_PHYLO) {
            return d5;
        }
        if (this.summaryStat == summaryStatistic.WAVEFRONT_RATE) {
            return d6;
        }
        if (this.summaryStat == summaryStatistic.DIFFUSION_DISTANCE) {
            return d2;
        }
        if (this.summaryStat == summaryStatistic.DISTANCE_TIME_CORRELATION) {
            if (this.summaryMode == Mode.SPEARMAN) {
                return ContinuousDiffusionStatistic.getSpearmanRho(ContinuousDiffusionStatistic.convertDoubles(arrayList3), ContinuousDiffusionStatistic.convertDoubles(arrayList2));
            }
            if (this.summaryMode == Mode.R_SQUARED) {
                object = new Regression(ContinuousDiffusionStatistic.convertDoubles(arrayList3), ContinuousDiffusionStatistic.convertDoubles(arrayList2));
                return ((Regression)object).getRSquared();
            }
            object = new Regression(ContinuousDiffusionStatistic.convertDoubles(arrayList3), ContinuousDiffusionStatistic.convertDoubles(arrayList2));
            return ((Regression)object).getCorrelationCoefficient();
        }
        if (this.summaryStat == summaryStatistic.SQUAREDDISTANCE_TIME4_CORRELATION) {
            object = ContinuousDiffusionStatistic.squareElements(arrayList2);
            if (this.summaryMode == Mode.SPEARMAN) {
                return ContinuousDiffusionStatistic.getSpearmanRho(ContinuousDiffusionStatistic.convertDoubles(arrayList3), ContinuousDiffusionStatistic.convertDoubles((List<Double>)object));
            }
            if (this.summaryMode == Mode.R_SQUARED) {
                Regression regression = new Regression(ContinuousDiffusionStatistic.convertDoubles(arrayList3), ContinuousDiffusionStatistic.convertDoubles((List<Double>)object));
                return regression.getRSquared();
            }
            Regression regression = new Regression(ContinuousDiffusionStatistic.convertDoubles(arrayList3), ContinuousDiffusionStatistic.convertDoubles((List<Double>)object));
            return regression.getCorrelationCoefficient();
        }
        return d;
    }

    private double getNativeDistance(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += Math.pow(dArray2[i] - dArray[i], 2.0);
        }
        return Math.sqrt(d);
    }

    public static double getGreatCircleDistance(double[] dArray, double[] dArray2) {
        SphericalPolarCoordinates sphericalPolarCoordinates = new SphericalPolarCoordinates(dArray[0], dArray[1]);
        SphericalPolarCoordinates sphericalPolarCoordinates2 = new SphericalPolarCoordinates(dArray2[0], dArray2[1]);
        return sphericalPolarCoordinates.distance(sphericalPolarCoordinates2);
    }

    private double[] toArray(List<Double> list) {
        double[] dArray = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            dArray[i] = Double.valueOf(list.get(i).toString());
        }
        return dArray;
    }

    private static List<Double> squareElements(List<Double> list) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (Double d : list) {
            arrayList.add(d * d);
        }
        return arrayList;
    }

    private double[] imputeValue(double[] dArray, double[] dArray2, double d, double d2, double d3, double[] dArray3, double d4, boolean bl) {
        int n;
        double d5 = (d - d2) * d4;
        double d6 = (d3 - d) * d4;
        double d7 = 1.0 / d5 + 1.0 / d6;
        int n2 = dArray.length;
        double[][] dArray4 = new double[n2][n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray4[i][j] = dArray3[n3];
                ++n3;
            }
        }
        if (d5 == 0.0) {
            return dArray;
        }
        if (d6 == 0.0) {
            return dArray2;
        }
        double[] dArray5 = new double[n2];
        double[][] dArray6 = new double[n2][n2];
        for (int i = 0; i < n2; ++i) {
            dArray5[i] = (dArray[i] / d5 + dArray2[i] / d6) / d7;
            if (!bl) continue;
            for (n = i; n < n2; ++n) {
                double d8 = dArray4[i][n] * d7;
                dArray6[i][n] = d8;
                dArray6[n][i] = d8;
            }
        }
        if (bl) {
            dArray5 = MultivariateNormalDistribution.nextMultivariateNormalPrecision(dArray5, dArray6);
        }
        double[] dArray7 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray7[n] = dArray5[n];
        }
        return dArray7;
    }

    public static double[] parseVariableLengthDoubleArray(String string) throws Arguments.ArgumentException {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                arrayList.add(Double.parseDouble(stringTokenizer.nextToken()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new Arguments.ArgumentException();
            }
        }
        if (arrayList.size() > 0) {
            double[] dArray = new double[arrayList.size()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = (Double)arrayList.get(i);
            }
            return dArray;
        }
        return null;
    }

    @Override
    public String getDimensionName(int n) {
        if (this.getDimension() == 1) {
            return this.getStatisticName();
        }
        return this.getStatisticName() + ".height" + this.heightLowers[n];
    }

    public static void reverse(double[] dArray) {
        if (dArray == null) {
            return;
        }
        int n = 0;
        for (int i = dArray.length - 1; i > n; --i, ++n) {
            double d = dArray[i];
            dArray[i] = dArray[n];
            dArray[n] = d;
        }
    }

    public static double[] extractUnique(double[] dArray) {
        LinkedHashSet<Double> linkedHashSet = new LinkedHashSet<Double>();
        double[] dArray2 = dArray;
        int n = dArray2.length;
        for (int i = 0; i < n; ++i) {
            Double d = dArray2[i];
            linkedHashSet.add(d);
        }
        dArray2 = new double[linkedHashSet.size()];
        n = 0;
        for (Double d : linkedHashSet) {
            dArray2[n++] = d;
        }
        return dArray2;
    }

    public History setUpHistory(String string, int n, int n2, double d, double d2) {
        String[] stringArray;
        double[] dArray;
        boolean bl = false;
        if (string.equals("{}")) {
            dArray = new double[]{d2, d};
            stringArray = new String[]{this.getState(n)};
        } else {
            int n3;
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "},{");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                arrayList.add(string2);
            }
            int n4 = arrayList.size() / NUMBER_OF_HISTORY_ENTRIES;
            String[][] stringArray2 = new String[n4][NUMBER_OF_HISTORY_ENTRIES.intValue()];
            for (n3 = 0; n3 < n4; ++n3) {
                stringArray2[n3][0] = (String)arrayList.get(n3 * NUMBER_OF_HISTORY_ENTRIES);
                stringArray2[n3][1] = (String)arrayList.get(n3 * NUMBER_OF_HISTORY_ENTRIES + 1);
                stringArray2[n3][2] = (String)arrayList.get(n3 * NUMBER_OF_HISTORY_ENTRIES + 2);
            }
            dArray = new double[n4 + 2];
            stringArray = new String[n4 + 1];
            for (n3 = 0; n3 < n4; ++n3) {
                stringArray[n3] = stringArray2[n3][1];
                dArray[n3 + 1] = Double.valueOf(stringArray2[n3][0]);
            }
            if (!stringArray2[0][1].equals(this.getState(n2))) {
                System.err.println("mismatch in jump history and parent node state, continuous diffusion statistic will return NaN");
                bl = true;
            }
            stringArray[n4] = stringArray2[n4 - 1][2];
            if (!stringArray2[n4 - 1][2].equals(this.getState(n))) {
                System.err.println("mismatch in jump history and node state, continuous diffusion statistic will return NaN");
                bl = true;
            }
            dArray[0] = d2;
            dArray[n4 + 1] = d;
        }
        return new History(dArray, stringArray, bl);
    }

    private String getState(int n) {
        String string = null;
        try {
            string = this.markovJumpLikelihood.formattedState(new int[]{n}).replaceAll("\"", "");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.err.println("no state found for int = " + n + "...");
            System.exit(-1);
        }
        return string;
    }

    public double[] getStateTimeAndDistanceFromRoot(MutableTreeModel mutableTreeModel, NodeRef nodeRef, double d, AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood, String string, double[] dArray, double[] dArray2, BranchRateModel branchRateModel, boolean bl) {
        NodeRef nodeRef2 = nodeRef;
        double[] dArray3 = new double[]{0.0, 0.0};
        double[] dArray4 = abstractMultivariateTraitLikelihood.getTraitForNode(mutableTreeModel, mutableTreeModel.getRoot(), string);
        int n = 0;
        while (nodeRef2 != mutableTreeModel.getRoot()) {
            NodeRef nodeRef3 = mutableTreeModel.getParent(nodeRef2);
            History history = this.setUpHistory(this.markovJumpLikelihood.getHistoryForNode(mutableTreeModel, nodeRef2, SITE), this.markovJumpLikelihood.getStatesForNode(mutableTreeModel, nodeRef2)[SITE], this.markovJumpLikelihood.getStatesForNode(mutableTreeModel, nodeRef3)[SITE], mutableTreeModel.getNodeHeight(nodeRef2), mutableTreeModel.getNodeHeight(nodeRef3));
            if (n == 0 && d > mutableTreeModel.getNodeHeight(nodeRef2)) {
                history.truncateLower(d);
            }
            double d2 = branchRateModel != null ? branchRateModel.getBranchRate(mutableTreeModel, nodeRef2) : 1.0;
            double[] dArray5 = abstractMultivariateTraitLikelihood.getTraitForNode(mutableTreeModel, nodeRef3, string);
            double[] dArray6 = dArray;
            if (n > 0) {
                dArray6 = abstractMultivariateTraitLikelihood.getTraitForNode(mutableTreeModel, nodeRef2, string);
            }
            history.setTraitsforHeights(dArray5, dArray6, dArray2, d2, this.trueNoise);
            dArray3[0] = dArray3[0] + history.getStateTime(this.stateString);
            dArray3[1] = bl ? dArray3[1] + history.getStateDifferenceInGreatCircleDistanceFromRoot(this.stateString, dArray4) : dArray3[1] + history.getStateDifferenceInNativeDistanceFromRoot(this.stateString, dArray4);
            nodeRef2 = mutableTreeModel.getParent(nodeRef2);
            ++n;
        }
        return dArray3;
    }

    public double[] getTimeAndDistanceFromRoot(MutableTreeModel mutableTreeModel, NodeRef nodeRef, double d, AbstractMultivariateTraitLikelihood abstractMultivariateTraitLikelihood, String string, double[] dArray, boolean bl) {
        NodeRef nodeRef2 = nodeRef;
        double[] dArray2 = new double[]{0.0, 0.0};
        double[] dArray3 = abstractMultivariateTraitLikelihood.getTraitForNode(mutableTreeModel, mutableTreeModel.getRoot(), string);
        int n = 0;
        while (nodeRef2 != mutableTreeModel.getRoot()) {
            NodeRef nodeRef3 = mutableTreeModel.getParent(nodeRef2);
            double[] dArray4 = abstractMultivariateTraitLikelihood.getTraitForNode(mutableTreeModel, nodeRef3, string);
            double[] dArray5 = dArray;
            double d2 = d;
            if (n > 0) {
                dArray5 = abstractMultivariateTraitLikelihood.getTraitForNode(mutableTreeModel, nodeRef2, string);
                d2 = mutableTreeModel.getNodeHeight(nodeRef2);
            }
            dArray2[0] = dArray2[0] + (mutableTreeModel.getNodeHeight(nodeRef3) - d2);
            dArray2[1] = bl ? dArray2[1] + (ContinuousDiffusionStatistic.getGreatCircleDistance(dArray5, dArray3) - ContinuousDiffusionStatistic.getGreatCircleDistance(dArray4, dArray3)) : dArray2[1] + (this.getNativeDistance(dArray5, dArray3) - this.getNativeDistance(dArray4, dArray3));
            nodeRef2 = mutableTreeModel.getParent(nodeRef2);
            ++n;
        }
        return dArray2;
    }

    public boolean inClade(MutableTreeModel mutableTreeModel, NodeRef nodeRef, TaxonList taxonList) throws TreeUtils.MissingTaxonException {
        Set<String> set = TreeUtils.getLeavesForTaxa(mutableTreeModel, taxonList);
        NodeRef nodeRef2 = TreeUtils.getCommonAncestorNode(mutableTreeModel, set);
        Set<String> set2 = TreeUtils.getDescendantLeaves(mutableTreeModel, nodeRef2);
        Set<String> set3 = TreeUtils.getDescendantLeaves(mutableTreeModel, nodeRef);
        if (!set3.isEmpty()) {
            set3.removeAll(set2);
        }
        return set3.isEmpty();
    }

    private static boolean onAncestralPathTaxa(Tree tree, NodeRef nodeRef, TaxonList taxonList) throws TreeUtils.MissingTaxonException {
        if (tree.isExternal(nodeRef)) {
            return false;
        }
        Set<String> set = TreeUtils.getDescendantLeaves(tree, nodeRef);
        int n = set.size();
        Set<String> set2 = TreeUtils.getLeavesForTaxa(tree, taxonList);
        set.retainAll(set2);
        if (set.size() > 0) {
            if (set.size() == n) {
                Set<String> set3 = TreeUtils.getDescendantLeaves(tree, tree.getParent(nodeRef));
                set3.removeAll(set2);
                return set3.size() > 0;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean onAncestralPathTime(Tree tree, NodeRef nodeRef, double d) {
        double d2 = 0.0;
        Set<NodeRef> set = TreeUtils.getExternalNodes(tree, nodeRef);
        Set<NodeRef> set2 = TreeUtils.getExternalNodes(tree, nodeRef);
        for (NodeRef nodeRef2 : set) {
            void object;
            while (tree.getNodeHeight(nodeRef) > tree.getNodeHeight((NodeRef)object)) {
                if (!set2.contains(object)) {
                    set2.add((NodeRef)object);
                }
                NodeRef nodeRef3 = tree.getParent((NodeRef)object);
            }
        }
        for (NodeRef nodeRef4 : set2) {
            d2 += tree.getBranchLength(nodeRef4);
        }
        return d2 > d;
    }

    private static double getAreaFrom2Dtraits(List<double[]> list, double d) {
        Object[] objectArray;
        boolean bl = true;
        double d2 = 0.0;
        double[][] dArray = new double[2][list.size()];
        for (int i = 0; i < list.size(); ++i) {
            objectArray = list.get(i);
            dArray[0][i] = objectArray[0];
            dArray[1][i] = objectArray[1];
        }
        ContourWithSynder contourWithSynder = new ContourWithSynder(dArray[0], dArray[1], bl);
        objectArray = contourWithSynder.getContourPaths(d);
        boolean bl2 = true;
        for (double d3 : objectArray) {
            KMLCoordinates kMLCoordinates = new KMLCoordinates(d3.getAllX(), d3.getAllY());
            Element element = new Element("test");
            element.addContent(kMLCoordinates.toXML());
            Polygon2D polygon2D = new Polygon2D(element);
            d2 += polygon2D.calculateArea();
        }
        return d2;
    }

    private static double[] convertDoubles(List<Double> list) {
        double[] dArray = new double[list.size()];
        Iterator<Double> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            dArray[n] = iterator.next();
            ++n;
        }
        return dArray;
    }

    private static double getSpearmanRho(double[] dArray, double[] dArray2) {
        double[] dArray3 = new NaturalRanking().rank(dArray);
        double[] dArray4 = new NaturalRanking().rank(dArray2);
        double d = 0.0;
        for (int i = 0; i < dArray3.length; ++i) {
            d += Math.pow(dArray3[i] - dArray4[i], 2.0);
        }
        return 1.0 - 6.0 * d / ((double)dArray3.length * (Math.pow(dArray3.length, 2.0) - 1.0));
    }

    static enum Mode {
        AVERAGE,
        WEIGHTED_AVERAGE,
        MEDIAN,
        COEFFICIENT_OF_VARIATION,
        SPEARMAN,
        CORRELATION_COEFFICIENT,
        R_SQUARED;

    }

    static enum summaryStatistic {
        TRAIT,
        TRAIT2DAREA,
        DIFFUSION_TIME,
        DIFFUSION_DISTANCE,
        DIFFUSION_RATE,
        DIFFUSION_COEFFICIENT,
        WAVEFRONT_DISTANCE,
        WAVEFRONT_DISTANCE_PHYLO,
        WAVEFRONT_RATE,
        DISTANCE_TIME_CORRELATION,
        SQUAREDDISTANCE_TIME4_CORRELATION;

    }

    static enum BranchSet {
        ALL,
        CLADE,
        BACKBONE;

    }

    private class History {
        private double[] historyHeights;
        private String[] historyStates;
        private double[][] historyTraits;
        private boolean mismatch;

        public History(double[] dArray, String[] stringArray, boolean bl) {
            this.historyHeights = dArray;
            this.historyStates = stringArray;
            this.mismatch = bl;
        }

        public void truncateUpper(double d) {
            int n = -1;
            for (int i = 0; i < this.historyHeights.length - 1; ++i) {
                if (!(d < this.historyHeights[i]) || !(d > this.historyHeights[i + 1])) continue;
                n = i;
            }
            if (n < 0) {
                System.err.println("no upper truncation of discrete trait history on branch possible");
                System.exit(0);
            }
            double[] dArray = new double[this.historyHeights.length - n];
            String[] stringArray = new String[this.historyStates.length - n];
            dArray = Arrays.copyOfRange(this.historyHeights, n, this.historyHeights.length);
            dArray[0] = d;
            stringArray = Arrays.copyOfRange(this.historyStates, n, this.historyStates.length);
            this.historyHeights = dArray;
            this.historyStates = stringArray;
        }

        public void truncateLower(double d) {
            int n = -1;
            for (int i = this.historyHeights.length - 1; i > 0; --i) {
                if (!(d > this.historyHeights[i]) || !(d < this.historyHeights[i - 1])) continue;
                n = i;
            }
            if (n < 0) {
                System.err.println("no lower truncation of discrete trait history on branch possible");
                System.exit(0);
            }
            double[] dArray = new double[n + 1];
            String[] stringArray = new String[n];
            dArray = Arrays.copyOfRange(this.historyHeights, 0, n + 1);
            dArray[dArray.length - 1] = d;
            stringArray = Arrays.copyOfRange(this.historyStates, 0, n);
            this.historyHeights = dArray;
            this.historyStates = stringArray;
        }

        public double getStateTime(String string) {
            double d = 0.0;
            for (int i = 0; i < this.historyStates.length; ++i) {
                if (!string.equals(this.historyStates[i])) continue;
                d += this.historyHeights[i] - this.historyHeights[i + 1];
            }
            return d;
        }

        public boolean returnMismatch() {
            return this.mismatch;
        }

        private void setTraitsforHeights(double[] dArray, double[] dArray2, double[] dArray3, double d, boolean bl) {
            this.historyTraits = new double[this.historyHeights.length][2];
            for (int i = 0; i < this.historyHeights.length; ++i) {
                this.historyTraits[i] = i == 0 ? dArray : (i == this.historyTraits.length - 1 ? dArray2 : ContinuousDiffusionStatistic.this.imputeValue(dArray, dArray2, this.historyHeights[i], this.historyHeights[this.historyHeights.length - 1], this.historyHeights[0], dArray3, d, bl));
            }
        }

        public double getStateGreatCircleDistance(String string) {
            double d = 0.0;
            for (int i = 0; i < this.historyStates.length; ++i) {
                if (!string.equals(this.historyStates[i])) continue;
                d += ContinuousDiffusionStatistic.getGreatCircleDistance(this.historyTraits[i], this.historyTraits[i + 1]);
            }
            return d;
        }

        public double getStateDifferenceInGreatCircleDistanceFromRoot(String string, double[] dArray) {
            double d = 0.0;
            for (int i = 0; i < this.historyStates.length; ++i) {
                if (!string.equals(this.historyStates[i])) continue;
                d += ContinuousDiffusionStatistic.getGreatCircleDistance(this.historyTraits[i + 1], dArray) - ContinuousDiffusionStatistic.getGreatCircleDistance(this.historyTraits[i], dArray);
            }
            return d;
        }

        public double getStateNativeDistance(String string) {
            double d = 0.0;
            for (int i = 0; i < this.historyStates.length; ++i) {
                if (!string.equals(this.historyStates[i])) continue;
                d += ContinuousDiffusionStatistic.this.getNativeDistance(this.historyTraits[i], this.historyTraits[i + 1]);
            }
            return d;
        }

        public double getStateDifferenceInNativeDistanceFromRoot(String string, double[] dArray) {
            double d = 0.0;
            for (int i = 0; i < this.historyStates.length; ++i) {
                if (!string.equals(this.historyStates[i])) continue;
                d += ContinuousDiffusionStatistic.this.getNativeDistance(this.historyTraits[i + 1], dArray) - ContinuousDiffusionStatistic.this.getNativeDistance(this.historyTraits[i], dArray);
            }
            return d;
        }
    }
}

