/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.basta;

import dr.evolution.alignment.SimpleAlignment;
import dr.evolution.alignment.SimpleSiteList;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.GeneralDataType;
import dr.evolution.datatype.Nucleotides;
import dr.evolution.io.NewickImporter;
import dr.evolution.sequence.Sequence;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Date;
import dr.evolution.util.Taxa;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evolution.util.Units;
import dr.evomodel.branchratemodel.DefaultBranchRateModel;
import dr.evomodel.coalescent.basta.StructuredCoalescentLikelihood;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.SVSComplexSubstitutionModel;
import dr.evomodel.tree.DefaultTreeModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Parameter;
import dr.inference.operators.ScaleOperator;
import dr.math.MathUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Logger;

public class BASTATreeMoveTester {
    private static final String DEME = "deme";
    private static String[][] sequences = new String[][]{{"AB192965Japan2004", "AF071228Spain1997", "AF105975Portugal1995", "AF189018Indonesia2005"}, {"ATGTGGGATCCACTTCTAAATGAATTTCCTGAATCTGTTCACGGATTTCGTTGTATGTTAGCTATTAAATATTTGCAGTCCGTTGAGGAAACTTACGAGCCCAATACATTGGGCCACGATTTAATTAGGGATCTTATATCTGTTGTAAGGGCCCGTGACTATGTCGAAGCGACCAGGCGATATAATCATTTCCACGCCCGCCTCGAAGGTTCGCCGAAGGCTGAACTTCGACAGCCCATACAGCAGCCGTGCTGCTGTCCCCATTGTCCAAGGCACAA---ACAAGCGACGATCATGGACGTACAGGCCCATGTACCGGAAGCCCAGAATATACAGAATGTATCGAAGCCCTGATGTTCCTCGTGGATGTGAAGGCCCATGTAAAGTCCAGTCTTATGAGCAACGGGATGATATTAAGCATACTGGTATTGTTCGTTGTGTTAGTGATGTTACTCGTGGATCTGGAATTACTCACAGAGTGGGTAAGAGGTTCTGTGTTAAATCGATATATTTTTTAGGTAAAGTCTGGATGGATGAAAATATCAAGAAGCAGAATCACACTAATCAGGTCATGTTCTTCTTGGTTCGTGATAGAAGGCCCTATGGAAACAGCCCAATGGATTTTGGACAGGTTTTTAATATGTTCGATAATGAGCCCAGTACCGCAACTGTGAAGAATGATTTGCGGGATAGGTTTCAAGTGATGAGGAAATTTCATGCTACAGTTATTGGTGGGCCCTCTGGAATGAAGGAACAGGCATTAGTTAAGAGATTTTTTAGAATTAACAGTCATGTAACTT-----ATAATCAT-CAGGAGGCAGCCAAGTATGAGAACCATACTGAAAACGCCTTGTTATTGTATATGGCATGTACGCATGCCTCTAATCCAGTGTATGCAACTATGAAAATACGCATCTATTTCTATGATTCAATATCAAATTAA", "ATGTGGGATCCACTTCTAAATGAATTTCCTGAATCTGTTCACGGATTTCGTTGTATGTTAGCTATTAAATATTTGCAGTCCGTTGAGGAAACTTACGAGCCCAATACATTGGGCCACGATTTAATTAGGGATCTTATATCTGTTGTAAGGGCCCGTGACTATGTCGAAGCGACCAGGCGATATAATCATTTCCACGCCCGCCTCGAAGGTTCGCCGAAGGCTGAACTTCGACAGCCCATACAGCAGCCGTGCTGCTGTCCCCATTGTCCAAGGCACAA---ACAAGCGACGATCATGGACGTACAGGCCCATGTACCGGAAGCCCAGAATATACAGAATGTATCGAAGCACTGATGTTCCCCGTGGATGTGAAGGCCCATGTAAAGTACAGTCTTATGAGCAACGGGATGATATTAAGCATACTGGTATTGTTCGTTGTGTTAGTGATGTTACTCGTGGATCTGGAATTACTCACAGAGTGGGTAAGAGGTTCTGTGTTAAATCGATATATTTTTTAGGTAAAGTCTGGATGGATGAAAATATCAAGAAGCAGAACCACACTAATCAGGTCATGTTCTTCTTGGTCCGTGATAGAAGGCCCTATGGAAACAGCCCAATGGATTTTGGACAGGTTTTTAATATGTTCGATAATGAGCCCAGTACCGCAACAGTGAAGAATGATTTGCGGGATAGGTTTCAAGTGATGAGGAAATTTCATGCTACAGTTATTGGTGGGCCCTCTGGAATGAAGGAACAGGCATTAGTTAAGAGGTTTTTTAGAATTAACAGTCATGTAACTT-----ATAATCAT-CAGGAGGCAGCCAAGTACGAGAACCATACTGAAAACGCCTTGTTATTGTATATGGCATGTACGCATGCCTCTAATCCAGTGTATGCTACTATGAAAATACGCATCTATTTCTATGATTCAATATCAAATTAA", "ATGTGGGATCCACTTCTAAATGAATTTCCTGAATCTGTTCACGGATTTCGTTGTATGTTAGCTATTAAATATTTGCAGTCCGTTGAGGAAACTTACGAGCCCAATACATTGGGCCACGATTTAATTAGGGATCTTATATCTGTTGTAAGGGCCCGTGACTATGTCGAAGCGACCAGGCGATATAATCATTTCCACGCCCGCCTCGAAGGTTCGCCGAAGGCTGAACTTCGACAGCCCATACAGCAGCCGTGCTGCTGTCCCCATTGTCCAAGGCACAA---ACAAGCGACGATCATGGACGTACAGGCCCATGTACCGGAAGCCCAGAATATACAGAATGTATCGAAGCCCTGATGTTCCCCGTGGATGTGAAGGCCCATGTAAAGTACAGTCTTATGAGCAACGGGATGATATTAAGCATACTGGTATTGTTCGTTGTGTTAGTGATGTTACTCGTGGATCTGGAATTACTCACAGAGTGGGTAAGAGGTTCTGTGTTAAATCGATATATTTTTTAGGTAAAGTCTGGATGGATGAAAATATCAAGAAGCAGAATCACACTAATCAGGTCATGTTCTTCTTGGTCCGTGATAGAAGGCCCTATGGAAACAGCCCAATGGATTTTGGACAGGTTTTTAATATGTTCGATAATGAGCCCAGTACCGCAACAGTGAAGAATGATTTGCGGGATAGGTTTCAAGTGATGAGGAAATTTCATGCTACAGTTATTGGTGGGCCCTCTGGAATGAAGGAACAGGCATTAGTTAAGAGATTTTTTAGAATTAACAGTCATGTAACTT-----ATAATCAT-CAGGAGGCAGCCAAGTACGAGAACCATACTGAAAACGCCTTGTTATTGTATATGGCATGTACGCATGCCTCTAATCCAGTGTATGCAACTATGAAAATACGCATCTATTTCTATGATTCAATATCAAATTAA", "ATGTGGGATCCTCTTTTAAACGAATTTCCGGATTCTGTTCACGGTTTTCGGTGTATGCTCGCAATAAAGTATTTGCAAGGCGTTGAAGCAACCTACGCCCCTGATACTGTCGGTTACGACCTAGTTCGAGATCTGATCTCAGTTGTTCGTGCGAGCAATTATGCTGAAGCGTGCCGGAGATATAGCCTTTTCCGGTCCCGTATCGAAAGTACGCCGTCGTCTCAATTACGACAGCCCAGGTACCAGCCGTGCTGCTGTACTCACTGCCCTCGGCATAA---ATCGAAAGAAGTCTTGGACTTCTCGGCCTATGTACCGGAAGCCCAGGATTTACCGGATGTACCGAACAGCTGATGTCCCTAGGGGATGTGAAGGTCCTTGCAAGATTCAATCCTTTGAATCTCGACATGATATTGCTCACACCGGTAAGGTTATGTGTGTGACGGATGTTACTCGTGGCGGTGGTTTAACCCACCGTACTGGGAAGAGATTTTGCGTTAAGTCCCTCTATATCCTTGGCAAAATCTGGATGGATGAAAATATCAAGACTAAGAATCACACTAACACGGTCATGTTCTATGTTGTTCGGGATCGTAGACCCTATGGTA-C-TCCT-CAAGATTTTGGACAAGTGTTTAACATGTTCGATAACGAACCTAGCACTGCAACTGTCAAGAATGATCTTCGAGATCGGTTTCAAGTTTTGCGGAAGTTCACGGCAACTGTTGTTGGTGGTCAGTATGCTTGTAAGGAACAAACGTTAGTTAGGAAGTTCATGAGATTGAACAATTATGTTGTTT-----ACAACCAT-CAGGAAACCGCAAAATATGAGAATCATACAGAGAATGCTCTGTTATTGTACATGGCATCTACGCATGCCTCTAACCCTGTGTATGCAACTTTGAAAATTCGGATCTATTTTTATGATTCGATAACAAATTAA"}};

    private static TreeModel createSpecifiedTree(String string) throws Exception {
        NewickImporter newickImporter = new NewickImporter(string);
        Tree tree = newickImporter.importTree(null);
        return new DefaultTreeModel(tree);
    }

    private static SimpleAlignment createAlignment(Object[][] objectArray, DataType dataType) {
        SimpleAlignment simpleAlignment = new SimpleAlignment();
        simpleAlignment.setDataType(dataType);
        Taxon[] taxonArray = new Taxon[objectArray[0].length];
        System.out.println("Taxon len = " + objectArray[0].length);
        System.out.println("Alignment len = " + objectArray[1].length);
        if (objectArray.length > 2) {
            System.out.println("Date len = " + objectArray[2].length);
        }
        for (int i = 0; i < objectArray[0].length; ++i) {
            Serializable serializable;
            taxonArray[i] = new Taxon(objectArray[0][i].toString());
            if (objectArray.length > 2) {
                serializable = new Date((Double)objectArray[2][i], Units.Type.YEARS, (Boolean)objectArray[3][0]);
                taxonArray[i].setDate((Date)serializable);
            }
            serializable = new Sequence(objectArray[1][i].toString());
            serializable.setTaxon(taxonArray[i]);
            serializable.setDataType(dataType);
            simpleAlignment.addSequence((Sequence)serializable);
        }
        return simpleAlignment;
    }

    public static void main(String[] stringArray) {
        TreeModel treeModel;
        MathUtils.setSeed(666L);
        Logger logger = Logger.getLogger("dr");
        logger.setUseParentHandlers(false);
        System.out.println("EXAMPLE 1: 4 taxa with 2 demes");
        SimpleAlignment simpleAlignment = BASTATreeMoveTester.createAlignment(sequences, Nucleotides.INSTANCE);
        try {
            treeModel = BASTATreeMoveTester.createSpecifiedTree("(((AB192965Japan2004:0.42343888910376215,AF189018Indonesia2005:1.4234388891037622)5:9.725099517053918,AF071228Spain1997:3.14853840615768)6:1.7275747971782511,AF105975Portugal1995:2.8761132033359313)");
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to parse Newick tree");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Asia");
        arrayList.add("West_Medit");
        GeneralDataType generalDataType = new GeneralDataType(arrayList);
        Taxa taxa = new Taxa();
        Taxon taxon = new Taxon(sequences[0][0]);
        taxon.setAttribute(DEME, arrayList.get(0));
        taxa.addTaxon(taxon);
        Taxon taxon2 = new Taxon(sequences[0][1]);
        taxon2.setAttribute(DEME, arrayList.get(1));
        taxa.addTaxon(taxon2);
        Taxon taxon3 = new Taxon(sequences[0][2]);
        taxon3.setAttribute(DEME, arrayList.get(1));
        taxa.addTaxon(taxon3);
        Taxon taxon4 = new Taxon(sequences[0][3]);
        taxon4.setAttribute(DEME, arrayList.get(0));
        taxa.addTaxon(taxon4);
        int[] nArray = new int[sequences[0].length];
        nArray[0] = 0;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 0;
        SimpleSiteList simpleSiteList = new SimpleSiteList(generalDataType, taxa);
        simpleSiteList.addPattern(nArray);
        double[] dArray = new double[]{0.5, 0.5};
        FrequencyModel frequencyModel = new FrequencyModel((DataType)generalDataType, dArray);
        Parameter.Default default_ = new Parameter.Default("migration rates", 2);
        default_.setParameterValue(0, 1.0);
        default_.setParameterValue(1, 1.0);
        Parameter.Default default_2 = new Parameter.Default("population sizes", 2);
        default_2.setParameterValue(0, 1.0);
        default_2.setParameterValue(1, 1.0);
        SVSComplexSubstitutionModel sVSComplexSubstitutionModel = new SVSComplexSubstitutionModel("migrationModel", (DataType)generalDataType, frequencyModel, (Parameter)default_, null);
        TaxonList taxonList = null;
        ArrayList<TaxonList> arrayList2 = new ArrayList<TaxonList>();
        int n = 2;
        DefaultBranchRateModel defaultBranchRateModel = new DefaultBranchRateModel();
        StructuredCoalescentLikelihood structuredCoalescentLikelihood = null;
        try {
            structuredCoalescentLikelihood = new StructuredCoalescentLikelihood(treeModel, defaultBranchRateModel, default_2, simpleSiteList, null, "", sVSComplexSubstitutionModel, n, taxonList, arrayList2, false);
        }
        catch (TreeUtils.MissingTaxonException missingTaxonException) {
            System.out.println("Error thrown in test class dr.evomodel.coalescent.basta.SCLikelihoodTester: " + missingTaxonException);
        }
        System.out.println("Structured coalescent lnL = " + structuredCoalescentLikelihood.getLogLikelihood() + "\n");
        ScaleOperator scaleOperator = new ScaleOperator(treeModel.getVariable(0), 0.75);
        scaleOperator.doOperation();
        System.out.println("Structured coalescent lnL = " + structuredCoalescentLikelihood.getLogLikelihood() + "\n");
        System.out.println("MODIFIED EXAMPLE 1: 4 taxa with 2 demes (altered root height)");
        try {
            treeModel = BASTATreeMoveTester.createSpecifiedTree("(((AB192965Japan2004:0.42343888910376215,AF189018Indonesia2005:1.4234388891037622):9.725099517053918,AF071228Spain1997:3.14853840615768):1.9314982732284278,AF105975Portugal1995:3.080036679386108)");
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to parse Newick tree");
        }
        try {
            structuredCoalescentLikelihood = new StructuredCoalescentLikelihood(treeModel, defaultBranchRateModel, default_2, simpleSiteList, null, "", sVSComplexSubstitutionModel, n, taxonList, arrayList2, false);
        }
        catch (TreeUtils.MissingTaxonException missingTaxonException) {
            System.out.println("Error thrown in test class dr.evomodel.coalescent.basta.SCLikelihoodTester: " + missingTaxonException);
        }
        System.out.println("Check structured coalescent lnL = " + structuredCoalescentLikelihood.getLogLikelihood() + "\n");
        ScaleOperator scaleOperator2 = new ScaleOperator(treeModel.getVariable(1), 0.75);
        scaleOperator2.doOperation();
        System.out.println("Structured coalescent lnL = " + structuredCoalescentLikelihood.getLogLikelihood() + "\n");
        System.out.println("MODIFIED EXAMPLE 1: 4 taxa with 2 demes (altered node height)");
        try {
            treeModel = BASTATreeMoveTester.createSpecifiedTree("(((AB192965Japan2004:0.42343888910376215,AF189018Indonesia2005:1.4234388891037622):8.95084315354517,AF071228Spain1997:2.3742820426489324):2.7057546367371756,AF105975Portugal1995:3.080036679386108)");
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to parse Newick tree");
        }
        try {
            structuredCoalescentLikelihood = new StructuredCoalescentLikelihood(treeModel, defaultBranchRateModel, default_2, simpleSiteList, null, "", sVSComplexSubstitutionModel, n, taxonList, arrayList2, false);
        }
        catch (TreeUtils.MissingTaxonException missingTaxonException) {
            System.out.println("Error thrown in test class dr.evomodel.coalescent.basta.SCLikelihoodTester: " + missingTaxonException);
        }
        System.out.println("Check structured coalescent lnL = " + structuredCoalescentLikelihood.getLogLikelihood() + "\n");
    }
}

