/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.coalescent.TreeIntervals;
import dr.evolution.tree.Tree;
import dr.inference.model.Statistic;

public class CoalescentTreeIntervalStatistic
extends Statistic.Abstract {
    private Tree tree;
    private TreeIntervals intervals;
    private int dimension;
    private double[] nonZeroIntervals;
    private int[] lineageCounts;

    public CoalescentTreeIntervalStatistic(Tree tree) {
        this.tree = tree;
        this.intervals = new TreeIntervals(tree);
        this.setDimension(this.intervals);
        this.lineageCounts = new int[this.dimension];
        this.nonZeroIntervals = new double[this.dimension];
        this.removeZeroLengthIntervals(this.intervals);
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public double getStatisticValue(int n) {
        if (n == 0) {
            this.intervals.setIntervalsUnknown();
            this.removeZeroLengthIntervals(this.intervals);
        }
        return this.nonZeroIntervals[n];
    }

    public double getLineageCount(int n) {
        if (n == 0) {
            this.intervals.setIntervalsUnknown();
            this.removeZeroLengthIntervals(this.intervals);
        }
        return this.lineageCounts[n];
    }

    @Override
    public String getStatisticName() {
        return "coalescentTreeIntervalStatistic";
    }

    private void setDimension(TreeIntervals treeIntervals) {
        int n = treeIntervals.getIntervalCount();
        for (int i = 0; i < treeIntervals.getIntervalCount(); ++i) {
            if (treeIntervals.getInterval(i) != 0.0) continue;
            --n;
        }
        this.dimension = n;
    }

    private void removeZeroLengthIntervals(TreeIntervals treeIntervals) {
        int n = 0;
        for (int i = 0; i < treeIntervals.getIntervalCount(); ++i) {
            double d = treeIntervals.getInterval(i);
            if (d == 0.0) continue;
            this.nonZeroIntervals[n] = d;
            this.lineageCounts[n] = treeIntervals.getLineageCount(i);
            ++n;
        }
    }
}

