/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg.likelihood;

import dr.evolution.alignment.PatternList;
import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.Codons;
import dr.evolution.datatype.Nucleotides;
import dr.evolution.datatype.OldHiddenNucleotides;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.TaxonList;
import dr.evomodel.arg.ARGModel;
import dr.evomodel.arg.ARGTree;
import dr.evomodel.arg.likelihood.AbstractARGLikelihood;
import dr.evomodel.arg.operators.ARGPartitioningOperator;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.branchratemodel.DefaultBranchRateModel;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.oldevomodel.sitemodel.SiteModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.treelikelihood.AminoAcidLikelihoodCore;
import dr.oldevomodel.treelikelihood.GeneralLikelihoodCore;
import dr.oldevomodel.treelikelihood.LikelihoodCore;
import dr.oldevomodel.treelikelihood.NativeAminoAcidLikelihoodCore;
import dr.oldevomodel.treelikelihood.NativeCovarionLikelihoodCore;
import dr.oldevomodel.treelikelihood.NativeNucleotideLikelihoodCore;
import dr.oldevomodel.treelikelihood.NucleotideLikelihoodCore;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ARGLikelihood
extends AbstractARGLikelihood {
    public static final String ARG_LIKELIHOOD = "argTreeLikelihood";
    public static final String USE_AMBIGUITIES = "useAmbiguities";
    public static final String STORE_PARTIALS = "storePartials";
    public static final String USE_SCALING = "useScaling";
    private static final boolean NO_CACHING = false;
    private Set<NodeRef> unsetNodes = null;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("useAmbiguities", true), AttributeRule.newBooleanRule("storePartials", true), AttributeRule.newBooleanRule("useScaling", true), new ElementRule(PatternList.class), new ElementRule(ARGModel.class), new ElementRule(SiteModel.class), new ElementRule(BranchRateModel.class, true)};

        @Override
        public String getParserName() {
            return ARGLikelihood.ARG_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = false;
            if (xMLObject.hasAttribute(ARGLikelihood.USE_AMBIGUITIES)) {
                bl = xMLObject.getBooleanAttribute(ARGLikelihood.USE_AMBIGUITIES);
            }
            if (xMLObject.hasAttribute(ARGLikelihood.STORE_PARTIALS)) {
                bl2 = xMLObject.getBooleanAttribute(ARGLikelihood.STORE_PARTIALS);
            }
            if (xMLObject.hasAttribute(ARGLikelihood.USE_SCALING)) {
                bl3 = xMLObject.getBooleanAttribute(ARGLikelihood.USE_SCALING);
            }
            PatternList patternList = (PatternList)xMLObject.getChild(PatternList.class);
            ARGModel aRGModel = (ARGModel)xMLObject.getChild(ARGModel.class);
            SiteModel siteModel = (SiteModel)xMLObject.getChild(SiteModel.class);
            BranchRateModel branchRateModel = (BranchRateModel)xMLObject.getChild(BranchRateModel.class);
            return new ARGLikelihood(patternList, aRGModel, siteModel, branchRateModel, bl, bl2, bl3);
        }

        @Override
        public String getParserDescription() {
            return "This element represents the likelihood of a patternlist on a tree given the site model.";
        }

        @Override
        public Class getReturnType() {
            return Likelihood.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    protected FrequencyModel frequencyModel = null;
    protected SiteModel siteModel = null;
    protected BranchRateModel branchRateModel = null;
    private boolean storePartials = false;
    private boolean integrateAcrossCategories = false;
    protected int[] siteCategories = null;
    protected double[] rootPartials = null;
    protected double[] patternLogLikelihoods = null;
    protected int categoryCount;
    protected double[] probabilities;
    protected LikelihoodCore likelihoodCore;
    private boolean useAmbiguities;
    private boolean reconstructTree = true;
    private ARGTree tree = null;
    private ARGTree oldTree;
    private Map<NodeRef, Integer> mapARGNodesToInts = null;
    private Map<NodeRef, Integer> oldMapARGNodesToInts;
    private Map<NodeRef, NodeRef> mapARGNodesToTreeNodes = null;
    private static final boolean DEBUG = true;

    public ARGLikelihood(PatternList patternList, ARGModel aRGModel, SiteModel siteModel, BranchRateModel branchRateModel, boolean bl, boolean bl2, boolean bl3) {
        super(ARG_LIKELIHOOD, patternList, aRGModel);
        this.partition = aRGModel.addLikelihoodCalculator(this);
        this.storePartials = bl2;
        this.useAmbiguities = bl;
        try {
            int n;
            this.siteModel = siteModel;
            this.addModel(siteModel);
            this.frequencyModel = siteModel.getFrequencyModel();
            this.addModel(this.frequencyModel);
            this.integrateAcrossCategories = siteModel.integrateAcrossCategories();
            this.categoryCount = siteModel.getCategoryCount();
            if (this.integrateAcrossCategories) {
                if (patternList.getDataType() instanceof Nucleotides) {
                    if (NativeNucleotideLikelihoodCore.isAvailable()) {
                        Logger.getLogger("dr.evomodel").info("TreeLikelihood using native nucleotide likelihood core");
                        this.likelihoodCore = new NativeNucleotideLikelihoodCore();
                    } else {
                        Logger.getLogger("dr.evomodel").info("TreeLikelihood using Java nucleotide likelihood core");
                        this.likelihoodCore = new NucleotideLikelihoodCore();
                    }
                } else if (patternList.getDataType() instanceof AminoAcids) {
                    if (NativeAminoAcidLikelihoodCore.isAvailable()) {
                        Logger.getLogger("dr.evomodel").info("TreeLikelihood using native amino acid likelihood core");
                        this.likelihoodCore = new NativeAminoAcidLikelihoodCore();
                    } else {
                        Logger.getLogger("dr.evomodel").info("TreeLikelihood using java likelihood core");
                        this.likelihoodCore = new AminoAcidLikelihoodCore();
                    }
                } else {
                    if (patternList.getDataType() instanceof Codons) {
                        Logger.getLogger("dr.evomodel").info("TreeLikelihood using Java codon likelihood core");
                        this.useAmbiguities = true;
                        throw new RuntimeException("Still need to merge codon likelihood core");
                    }
                    if (patternList.getDataType() instanceof OldHiddenNucleotides && NativeCovarionLikelihoodCore.isAvailable()) {
                        Logger.getLogger("dr.evomodel").info("TreeLikelihood using native covarion likelihood core");
                        this.likelihoodCore = new NativeCovarionLikelihoodCore();
                    } else {
                        Logger.getLogger("dr.evomodel").info("TreeLikelihood using Java general likelihood core");
                        this.likelihoodCore = new GeneralLikelihoodCore(patternList.getStateCount());
                    }
                }
            } else {
                Logger.getLogger("dr.evomodel").info("TreeLikelihood using Java general likelihood core");
                this.likelihoodCore = new GeneralLikelihoodCore(patternList.getStateCount());
            }
            Logger.getLogger("dr.evomodel").info("  " + (bl ? "Using" : "Ignoring") + " ambiguities in tree likelihood.");
            Logger.getLogger("dr.evomodel").info("  Partial likelihood scaling " + (bl3 ? "on." : "off."));
            if (branchRateModel != null) {
                this.branchRateModel = branchRateModel;
                Logger.getLogger("dr.evomodel").info("Branch rate model used: " + branchRateModel.getModelName());
            } else {
                this.branchRateModel = new DefaultBranchRateModel();
            }
            this.addModel(this.branchRateModel);
            this.probabilities = new double[this.stateCount * this.stateCount];
            this.likelihoodCore.initialize(this.nodeCount, this.patternCount, this.categoryCount, this.integrateAcrossCategories);
            int n2 = aRGModel.getExternalNodeCount();
            int n3 = aRGModel.getInternalNodeCount();
            for (n = 0; n < n2; ++n) {
                String string = aRGModel.getTaxonId(n);
                int n4 = patternList.getTaxonIndex(string);
                if (n4 == -1) {
                    throw new TaxonList.MissingTaxonException("Taxon, " + string + ", in tree, " + aRGModel.getId() + ", is not found in patternList, " + patternList.getId());
                }
                if (bl) {
                    this.setPartials(this.likelihoodCore, patternList, this.categoryCount, n4, n);
                    continue;
                }
                this.setStates(this.likelihoodCore, patternList, n4, n);
            }
            for (n = 0; n < n3; ++n) {
                this.likelihoodCore.createNodePartials(n2 + n);
            }
        }
        catch (TaxonList.MissingTaxonException missingTaxonException) {
            throw new RuntimeException(missingTaxonException.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.treeModel) {
            if (object instanceof ARGModel.ARGTreeChangedEvent) {
                ARGModel.ARGTreeChangedEvent aRGTreeChangedEvent = (ARGModel.ARGTreeChangedEvent)object;
                if (aRGTreeChangedEvent.isSizeChanged()) {
                    this.updateAllNodes();
                    this.reconstructTree = true;
                } else if (aRGTreeChangedEvent.isNodeChanged()) {
                    NodeRef nodeRef = this.mapARGNodesToTreeNodes.get(aRGTreeChangedEvent.getNode());
                    if (nodeRef != null) {
                        if (aRGTreeChangedEvent.isHeightChanged() || aRGTreeChangedEvent.isRateChanged()) {
                            this.updateNodeAndChildren(nodeRef);
                        } else {
                            this.reconstructTree = true;
                            this.updateAllNodes();
                        }
                    }
                } else {
                    if (!aRGTreeChangedEvent.isTreeChanged()) throw new RuntimeException("Another tree event has occured (possibly a trait change).");
                    this.reconstructTree = true;
                    this.updateAllNodes();
                }
            } else if (object instanceof ARGPartitioningOperator.PartitionChangedEvent) {
                boolean[] blArray = ((ARGPartitioningOperator.PartitionChangedEvent)object).getUpdatedPartitions();
                if (blArray[this.partition]) {
                    this.reconstructTree = true;
                    this.updateAllNodes();
                }
            } else if (!(object instanceof Parameter)) {
                throw new RuntimeException("Unexpected ARGModel update " + object.getClass());
            }
        } else if (model == this.branchRateModel) {
            this.updateAllNodes();
        } else if (model == this.frequencyModel) {
            this.updateAllNodes();
        } else {
            if (!(model instanceof SiteModel)) throw new RuntimeException("Unknown componentChangedEvent");
            this.updateAllNodes();
        }
        super.handleModelChangedEvent(model, object, n);
    }

    @Override
    protected void storeState() {
        if (this.storePartials) {
            this.likelihoodCore.storeState();
        }
        super.storeState();
    }

    @Override
    protected void restoreState() {
        if (this.storePartials) {
            this.likelihoodCore.restoreState();
        } else {
            this.updateAllNodes();
        }
        this.reconstructTree = true;
        super.restoreState();
    }

    private int getUnusedInt(Map<NodeRef, Integer> map) {
        Collection<Integer> collection = map.values();
        int n = this.tree.getExternalNodeCount();
        while (collection.contains(n)) {
            ++n;
        }
        return n;
    }

    private void reconstructTree() {
        this.oldTree = this.tree;
        this.oldMapARGNodesToInts = this.mapARGNodesToInts;
        this.tree = new ARGTree(this.treeModel, this.partition);
        this.reconstructTree = false;
        this.mapARGNodesToInts = new HashMap<NodeRef, Integer>(this.tree.getInternalNodeCount());
        this.mapARGNodesToTreeNodes = this.tree.getMapping();
        if (this.oldTree == null) {
            for (int i = 0; i < this.tree.getInternalNodeCount(); ++i) {
                NodeRef nodeRef = this.tree.getInternalNode(i);
                this.mapARGNodesToInts.put(this.treeModel.getMirrorNode(nodeRef), nodeRef.getNumber());
            }
        } else {
            if (this.unsetNodes == null) {
                this.unsetNodes = new HashSet<NodeRef>();
            } else {
                this.unsetNodes.clear();
            }
            for (int i = 0; i < this.tree.getInternalNodeCount(); ++i) {
                NodeRef nodeRef = this.tree.getInternalNode(i);
                NodeRef nodeRef2 = this.treeModel.getMirrorNode(nodeRef);
                if (this.oldMapARGNodesToInts.containsKey(nodeRef2)) {
                    int n = this.oldMapARGNodesToInts.get(nodeRef2);
                    this.treeModel.setNodeNumber(nodeRef, n);
                    this.mapARGNodesToInts.put(nodeRef2, n);
                    continue;
                }
                this.unsetNodes.add(nodeRef);
            }
            for (NodeRef nodeRef : this.unsetNodes) {
                int n = this.getUnusedInt(this.mapARGNodesToInts);
                this.treeModel.setNodeNumber(nodeRef, n);
                this.mapARGNodesToInts.put(nodeRef, n);
                this.updateNode[n] = true;
            }
        }
    }

    @Override
    protected double calculateLogLikelihood() {
        int n;
        if (this.reconstructTree) {
            this.reconstructTree();
        }
        NodeRef nodeRef = this.tree.getRoot();
        if (this.rootPartials == null) {
            this.rootPartials = new double[this.patternCount * this.stateCount];
        }
        if (this.patternLogLikelihoods == null) {
            this.patternLogLikelihoods = new double[this.patternCount];
        }
        if (!this.integrateAcrossCategories) {
            if (this.siteCategories == null) {
                this.siteCategories = new int[this.patternCount];
            }
            for (n = 0; n < this.patternCount; ++n) {
                this.siteCategories[n] = this.siteModel.getCategoryOfSite(n);
            }
        }
        try {
            this.traverse(this.tree, nodeRef);
        }
        catch (NegativeBranchLengthException negativeBranchLengthException) {
            System.err.println("Negative branch length found, trying to return 0 likelihood");
            return Double.NEGATIVE_INFINITY;
        }
        for (n = 0; n < this.nodeCount; ++n) {
            this.updateNode[n] = false;
        }
        double d = 0.0;
        for (int i = 0; i < this.patternCount; ++i) {
            d += this.patternLogLikelihoods[i] * this.patternWeights[i];
        }
        return d;
    }

    private boolean traverse(Tree tree, NodeRef nodeRef) throws NegativeBranchLengthException {
        int n;
        boolean bl = false;
        int n2 = nodeRef.getNumber();
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        if (nodeRef2 != null && this.updateNode[n2]) {
            double d = this.branchRateModel.getBranchRate(tree, nodeRef);
            double d2 = d * (tree.getNodeHeight(nodeRef2) - tree.getNodeHeight(nodeRef));
            if (d2 < 0.0) {
                throw new NegativeBranchLengthException();
            }
            for (n = 0; n < this.categoryCount; ++n) {
                double d3 = this.siteModel.getRateForCategory(n) * d2;
                this.siteModel.getSubstitutionModel().getTransitionProbabilities(d3, this.probabilities);
                this.likelihoodCore.setNodeMatrix(n2, n, this.probabilities);
            }
            bl = true;
        }
        if (!tree.isExternal(nodeRef)) {
            int n3 = tree.getChildCount(nodeRef);
            if (n3 != 2) {
                throw new RuntimeException("binary trees only!");
            }
            NodeRef nodeRef3 = tree.getChild(nodeRef, 0);
            boolean bl2 = this.traverse(tree, nodeRef3);
            NodeRef nodeRef4 = tree.getChild(nodeRef, 1);
            n = this.traverse(tree, nodeRef4) ? 1 : 0;
            if (bl2 || n != 0) {
                int n4 = nodeRef3.getNumber();
                int n5 = nodeRef4.getNumber();
                if (this.integrateAcrossCategories) {
                    this.likelihoodCore.calculatePartials(n4, n5, n2);
                } else {
                    this.likelihoodCore.calculatePartials(n4, n5, n2, this.siteCategories);
                }
                if (nodeRef2 == null) {
                    double[] dArray = this.frequencyModel.getFrequencies();
                    if (this.integrateAcrossCategories) {
                        double[] dArray2 = this.siteModel.getCategoryProportions();
                        this.likelihoodCore.integratePartials(n2, dArray2, this.rootPartials);
                    } else {
                        this.likelihoodCore.getPartials(n2, this.rootPartials);
                    }
                    this.likelihoodCore.calculateLogLikelihoods(this.rootPartials, dArray, this.patternLogLikelihoods);
                }
                bl = true;
            }
        }
        return bl;
    }

    class NegativeBranchLengthException
    extends Exception {
        NegativeBranchLengthException() {
        }
    }
}

