/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.parsimony;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.SimpleSiteList;
import dr.evolution.alignment.SiteList;
import dr.evolution.datatype.PairedDataType;
import dr.evolution.io.NexusImporter;
import dr.evolution.parsimony.ParsimonyCriterion;
import dr.evolution.parsimony.SankoffParsimony;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import java.io.FileReader;

public class TestParsimony {
    public static final String alignmentFileName = "ABLV.G.nuc";
    public static final String treeFileName = "ABLV.G.tree";

    public static void main(String[] stringArray) throws Exception {
        NexusImporter nexusImporter = new NexusImporter(new FileReader(alignmentFileName));
        Alignment alignment = nexusImporter.importAlignment();
        Tree tree = null;
        nexusImporter = new NexusImporter(new FileReader(treeFileName));
        try {
            tree = nexusImporter.importTree(alignment);
        }
        catch (Exception exception) {
            System.err.println("Exception attempting to read tree: " + exception.getMessage());
            System.exit(0);
        }
        System.out.println("single:");
        TestParsimony.testParsimony(new SankoffParsimony(alignment), alignment, tree);
        System.out.println("paired:");
        TestParsimony.testPairedSites(alignment, tree);
    }

    static void testPairedSites(SiteList siteList, Tree tree) {
        SankoffParsimony sankoffParsimony = new SankoffParsimony(siteList);
        double[] dArray = sankoffParsimony.getSiteScores(tree);
        PairedDataType pairedDataType = new PairedDataType(siteList.getDataType());
        for (int i = 0; i < siteList.getSiteCount(); ++i) {
            Object[] objectArray;
            if (!(dArray[i] > 0.0)) continue;
            SimpleSiteList simpleSiteList = new SimpleSiteList(pairedDataType, siteList);
            int[] nArray = new int[siteList.getSiteCount()];
            int n = 0;
            for (int j = i + 1; j < siteList.getSiteCount(); ++j) {
                if (!(dArray[j] > 0.0)) continue;
                objectArray = new int[siteList.getTaxonCount()];
                int[] nArray2 = siteList.getSitePattern(i);
                int[] nArray3 = siteList.getSitePattern(j);
                for (int k = 0; k < objectArray.length; ++k) {
                    objectArray[k] = pairedDataType.getState(nArray2[k], nArray3[k]);
                }
                simpleSiteList.addPattern((int[])objectArray);
                nArray[n] = j;
                ++n;
            }
            SankoffParsimony sankoffParsimony2 = new SankoffParsimony(simpleSiteList);
            objectArray = sankoffParsimony2.getSiteScores(tree);
            for (int j = 0; j < simpleSiteList.getSiteCount(); ++j) {
                if (!(objectArray[j] > 1.0)) continue;
                System.out.println("site {" + Integer.toString(i + 1) + ", " + Integer.toString(nArray[j] + 1) + "}: " + objectArray[j] + " steps");
                TestParsimony.showChanges(sankoffParsimony2, j, tree, tree.getRoot());
            }
        }
    }

    static void testParsimony(ParsimonyCriterion parsimonyCriterion, SiteList siteList, Tree tree) {
        double[] dArray = parsimonyCriterion.getSiteScores(tree);
        for (int i = 0; i < siteList.getSiteCount(); ++i) {
            if (!(dArray[i] > 1.0)) continue;
            System.out.println("site" + i + " (" + dArray[i] + " steps):");
            TestParsimony.showChanges(parsimonyCriterion, i, tree, tree.getRoot());
        }
    }

    static void showChanges(ParsimonyCriterion parsimonyCriterion, int n, Tree tree, NodeRef nodeRef) {
        int n2;
        if (nodeRef != tree.getRoot()) {
            n2 = parsimonyCriterion.getStates(tree, nodeRef)[n];
            int n3 = parsimonyCriterion.getStates(tree, tree.getParent(nodeRef))[n];
            if (n3 != n2) {
                if (tree.isExternal(nodeRef)) {
                    System.out.println("\tnode(" + tree.getParent(nodeRef).getNumber() + " -> " + tree.getNodeTaxon(nodeRef).getId() + "):\tstate(" + n3 + " -> " + n2 + ")");
                } else {
                    System.out.println("\tnode(" + tree.getParent(nodeRef).getNumber() + " -> " + nodeRef.getNumber() + "):\tstate(" + n3 + " -> " + n2 + ")");
                }
            }
        }
        for (n2 = 0; n2 < tree.getChildCount(nodeRef); ++n2) {
            TestParsimony.showChanges(parsimonyCriterion, n, tree, tree.getChild(nodeRef, n2));
        }
    }
}

