/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.coalescent;

public interface IntervalList {
    public int getIntervalCount();

    public int getSampleCount();

    public double getInterval(int var1);

    public int getLineageCount(int var1);

    public int getCoalescentEvents(int var1);

    public IntervalType getIntervalType(int var1);

    public double getTotalDuration();

    public boolean isBinaryCoalescent();

    public boolean isCoalescentOnly();

    public static class Utils {
        private Utils() {
        }

        public static int getLineageCount(IntervalList intervals, double t) {
            int i;
            for (i = 0; i < intervals.getIntervalCount() && t > intervals.getInterval(i); t -= intervals.getInterval(i), ++i) {
            }
            if (i == intervals.getIntervalCount()) {
                return 1;
            }
            return intervals.getLineageCount(i);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IntervalType {
        SAMPLE("sample"),
        COALESCENT("coalescent"),
        MIGRATION("migration"),
        NOTHING("nothing");

        private final String name;

        private IntervalType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

