/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.LUPDecomposition;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.NonSymmetricComponents;

public class SymmetricMatrix
extends Matrix {
    private static int lupCRLCriticalDimension = 36;

    public SymmetricMatrix(double[][] dArray) {
        super(dArray);
    }

    public SymmetricMatrix(double[] dArray, int n) {
        super(dArray, n, n);
    }

    public SymmetricMatrix(int n) throws NegativeArraySizeException {
        super(n, n);
    }

    public SymmetricMatrix(int n, int n2) throws NegativeArraySizeException {
        super(n, n2);
    }

    public void setSymmetric(int n, int n2, double d) {
        double d2 = d;
        this.components[n2][n] = d2;
        this.components[n][n2] = d2;
    }

    public static SymmetricMatrix compoundSymmetricMatrix(double[] dArray, double[] dArray2, int n) {
        if (n <= 0) {
            throw new NegativeArraySizeException("Requested matrix size: " + n);
        }
        assert (n == dArray.length) : "Requested matrix size: " + n + " doesn't match diagonal array size: " + dArray.length;
        assert (n * (n - 1) / 2 == dArray2.length) : "Requested matrix size: " + n + " doesn't match off diagonal array size: " + dArray2.length;
        double[][] dArray3 = new double[n][n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            dArray3[i][i] = dArray[i];
            for (int j = i + 1; j < n; ++j) {
                double d = dArray2[n2];
                dArray3[j][i] = d;
                dArray3[i][j] = d;
                ++n2;
            }
        }
        return new SymmetricMatrix(dArray3);
    }

    public static SymmetricMatrix compoundCorrelationSymmetricMatrix(double[] dArray, int n) {
        if (n <= 0) {
            throw new NegativeArraySizeException("Requested matrix size: " + n);
        }
        assert (n * (n - 1) / 2 == dArray.length) : "Requested matrix size: " + n + " doesn't match off diagonal array size: " + dArray.length;
        double[][] dArray2 = new double[n][n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            dArray2[i][i] = 1.0;
            for (int j = i + 1; j < n; ++j) {
                double d = dArray[n2];
                dArray2[j][i] = d;
                dArray2[i][j] = d;
                ++n2;
            }
        }
        return new SymmetricMatrix(dArray2);
    }

    public static double[] extractUpperTriangular(SymmetricMatrix symmetricMatrix) {
        int n = symmetricMatrix.columns();
        double[] dArray = new double[n * (n - 1) / 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                dArray[n2] = symmetricMatrix.components[i][j];
                ++n2;
            }
        }
        return dArray;
    }

    public SymmetricMatrix add(SymmetricMatrix symmetricMatrix) throws IllegalDimension {
        return new SymmetricMatrix(this.addComponents(symmetricMatrix));
    }

    private SymmetricMatrix crlInverse() throws ArithmeticException {
        if (this.rows() == 1) {
            return this.inverse1By1();
        }
        if (this.rows() == 2) {
            return this.inverse2By2();
        }
        Matrix[] matrixArray = this.split();
        SymmetricMatrix symmetricMatrix = (SymmetricMatrix)matrixArray[0].inverse();
        Matrix matrix = matrixArray[2].secureProduct(symmetricMatrix);
        SymmetricMatrix symmetricMatrix2 = new SymmetricMatrix(matrix.productWithTransposedComponents(matrixArray[2]));
        matrixArray[1] = ((SymmetricMatrix)matrixArray[1]).secureSubtract(symmetricMatrix2).inverse();
        matrixArray[2] = matrixArray[1].secureProduct(matrix);
        matrixArray[0] = symmetricMatrix.secureAdd(new SymmetricMatrix(matrix.transposedProductComponents(matrixArray[2])));
        return SymmetricMatrix.join(matrixArray);
    }

    public static SymmetricMatrix fromComponents(double[][] dArray) throws IllegalDimension, NonSymmetricComponents {
        if (dArray.length != dArray[0].length) {
            throw new IllegalDimension("Non symmetric components: a " + dArray.length + " by " + dArray[0].length + " matrix cannot be symmetric");
        }
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (dArray[i][j] == dArray[j][i]) continue;
                throw new NonSymmetricComponents("Non symmetric components: a[" + i + "][" + j + "]= " + dArray[i][j] + ", a[" + j + "][" + i + "]= " + dArray[j][i]);
            }
        }
        return new SymmetricMatrix(dArray);
    }

    public static SymmetricMatrix identityMatrix(int n) {
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray[i][j] = 0.0;
            }
            dArray[i][i] = 1.0;
        }
        return new SymmetricMatrix(dArray);
    }

    @Override
    public Matrix inverse() throws ArithmeticException {
        return this.rows() < lupCRLCriticalDimension ? new SymmetricMatrix(new LUPDecomposition(this).inverseMatrixComponents()) : this.crlInverse();
    }

    private SymmetricMatrix inverse1By1() {
        double[][] dArray = new double[1][1];
        dArray[0][0] = 1.0 / this.components[0][0];
        return new SymmetricMatrix(dArray);
    }

    private SymmetricMatrix inverse2By2() {
        double[][] dArray = new double[2][2];
        double d = 1.0 / (this.components[0][0] * this.components[1][1] - this.components[0][1] * this.components[1][0]);
        dArray[0][0] = d * this.components[1][1];
        dArray[1][1] = d * this.components[0][0];
        double d2 = -d * this.components[1][0];
        dArray[1][0] = d2;
        dArray[0][1] = d2;
        return new SymmetricMatrix(dArray);
    }

    private static SymmetricMatrix join(Matrix[] matrixArray) {
        int n;
        int n2;
        int n3 = matrixArray[0].rows();
        int n4 = n3 + matrixArray[1].rows();
        double[][] dArray = new double[n4][n4];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                dArray[n2][n] = matrixArray[0].components[n2][n];
            }
            for (n = n3; n < n4; ++n) {
                double d = -matrixArray[2].components[n - n3][n2];
                dArray[n][n2] = d;
                dArray[n2][n] = d;
            }
        }
        for (n2 = n3; n2 < n4; ++n2) {
            for (n = n3; n < n4; ++n) {
                dArray[n2][n] = matrixArray[1].components[n2 - n3][n - n3];
            }
        }
        return new SymmetricMatrix(dArray);
    }

    private int largestPowerOf2SmallerThan(int n) {
        int n2 = 2;
        int n3;
        while ((n3 = 2 * n2) < n) {
            n2 = n3;
        }
        return n2;
    }

    @Override
    public Matrix product(double d) {
        return new SymmetricMatrix(this.productComponents(d));
    }

    public SymmetricMatrix product(SymmetricMatrix symmetricMatrix) throws IllegalDimension {
        return new SymmetricMatrix(this.productComponents(symmetricMatrix));
    }

    public SymmetricMatrix productWithTransposed(SymmetricMatrix symmetricMatrix) throws IllegalDimension {
        if (symmetricMatrix.columns() != this.columns()) {
            throw new IllegalDimension("Operation error: cannot multiply a " + this.rows() + " by " + this.columns() + " matrix with the transpose of a " + symmetricMatrix.rows() + " by " + symmetricMatrix.columns() + " matrix");
        }
        return new SymmetricMatrix(this.productWithTransposedComponents(symmetricMatrix));
    }

    protected SymmetricMatrix secureAdd(SymmetricMatrix symmetricMatrix) {
        return new SymmetricMatrix(this.addComponents(symmetricMatrix));
    }

    protected SymmetricMatrix secureProduct(SymmetricMatrix symmetricMatrix) {
        return new SymmetricMatrix(this.productComponents(symmetricMatrix));
    }

    protected SymmetricMatrix secureSubtract(SymmetricMatrix symmetricMatrix) {
        return new SymmetricMatrix(this.subtractComponents(symmetricMatrix));
    }

    private Matrix[] split() {
        int n;
        int n2;
        int n3 = this.rows();
        int n4 = this.largestPowerOf2SmallerThan(n3);
        int n5 = n3 - n4;
        double[][] dArray = new double[n4][n4];
        double[][] dArray2 = new double[n5][n5];
        double[][] dArray3 = new double[n5][n4];
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n4; ++n) {
                dArray[n2][n] = this.components[n2][n];
            }
            for (n = n4; n < n3; ++n) {
                dArray3[n - n4][n2] = this.components[n2][n];
            }
        }
        for (n2 = n4; n2 < n3; ++n2) {
            for (n = n4; n < n3; ++n) {
                dArray2[n2 - n4][n - n4] = this.components[n2][n];
            }
        }
        Matrix[] matrixArray = new Matrix[]{new SymmetricMatrix(dArray), new SymmetricMatrix(dArray2), new Matrix(dArray3)};
        return matrixArray;
    }

    public SymmetricMatrix subtract(SymmetricMatrix symmetricMatrix) throws IllegalDimension {
        return new SymmetricMatrix(this.subtractComponents(symmetricMatrix));
    }

    @Override
    public Matrix transpose() {
        return this;
    }

    public SymmetricMatrix transposedProduct(SymmetricMatrix symmetricMatrix) throws IllegalDimension {
        if (symmetricMatrix.rows() != this.rows()) {
            throw new IllegalDimension("Operation error: cannot multiply a tranposed " + this.rows() + " by " + this.columns() + " matrix with a " + symmetricMatrix.rows() + " by " + symmetricMatrix.columns() + " matrix");
        }
        return new SymmetricMatrix(this.transposedProductComponents(symmetricMatrix));
    }
}

