/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.LUDecomposition;
import dr.evomodel.substmodel.FrequencyModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.List;

public class MarkovModulatedFrequencyModel
extends FrequencyModel {
    private List<FrequencyModel> freqModels;
    private final int numBaseModel;
    private final int totalFreqCount;
    private final int stateCount;
    private final Parameter switchingRates;
    private double[] baseStationaryDistribution;
    private double[] storedBaseStationaryDistribution;
    private boolean stationaryDistributionKnown;
    private boolean storedStationaryDistributionKnown;

    MarkovModulatedFrequencyModel(String string, List<FrequencyModel> list, Parameter parameter) {
        super(string);
        this.freqModels = list;
        int n = 0;
        this.stateCount = list.get(0).getFrequencyCount();
        this.numBaseModel = list.size();
        for (int i = 0; i < this.numBaseModel; ++i) {
            int n2 = list.get(i).getFrequencyCount();
            if (this.stateCount != n2) {
                throw new RuntimeException("MarkovModulatedFrequencyModel requires all frequencies model to have the same dimension");
            }
            this.addModel(list.get(i));
            n += n2;
        }
        this.totalFreqCount = n;
        this.switchingRates = parameter;
        this.addVariable(parameter);
        this.baseStationaryDistribution = new double[this.numBaseModel];
        this.storedBaseStationaryDistribution = new double[this.numBaseModel];
        this.stationaryDistributionKnown = false;
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(this.numBaseModel, this.numBaseModel);
        denseDoubleMatrix2D.set(0, 0, 1.0);
    }

    @Override
    public void setFrequency(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public double getFrequency(int n) {
        int n2 = n / this.stateCount;
        int n3 = n % this.stateCount;
        double d = this.freqModels.get(n2).getFrequency(n3) / (double)this.numBaseModel;
        if (this.numBaseModel > 1 && !this.stationaryDistributionKnown) {
            this.computeStationaryDistribution(this.baseStationaryDistribution);
            this.stationaryDistributionKnown = true;
        }
        return d;
    }

    private void computeStationaryDistribution(double[] dArray) {
        int n;
        int n2;
        int n3;
        if (MarkovModulatedFrequencyModel.allRatesAreZero(this.switchingRates)) {
            return;
        }
        DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(this.numBaseModel + 1, this.numBaseModel);
        int n4 = 0;
        for (n3 = 0; n3 < this.numBaseModel; ++n3) {
            for (n2 = n3 + 1; n2 < this.numBaseModel; ++n2) {
                denseDoubleMatrix2D.set(n2, n3, this.switchingRates.getParameterValue(n4));
                ++n4;
            }
        }
        for (n3 = 0; n3 < this.numBaseModel; ++n3) {
            for (n2 = n3 + 1; n2 < this.numBaseModel; ++n2) {
                denseDoubleMatrix2D.set(n3, n2, this.switchingRates.getParameterValue(n4));
                ++n4;
            }
        }
        for (n3 = 0; n3 < this.numBaseModel; ++n3) {
            double d = 0.0;
            for (n = 0; n < this.numBaseModel; ++n) {
                if (n3 == n) continue;
                d += denseDoubleMatrix2D.get(n, n3);
            }
            denseDoubleMatrix2D.set(n3, n3, -d);
        }
        for (n3 = 0; n3 < this.numBaseModel; ++n3) {
            denseDoubleMatrix2D.set(this.numBaseModel, n3, 1.0);
        }
        LUDecomposition lUDecomposition = new LUDecomposition(denseDoubleMatrix2D);
        DenseDoubleMatrix2D denseDoubleMatrix2D2 = new DenseDoubleMatrix2D(this.numBaseModel + 1, 1);
        denseDoubleMatrix2D2.set(this.numBaseModel, 0, 1.0);
        DoubleMatrix2D doubleMatrix2D = lUDecomposition.solve(denseDoubleMatrix2D2);
        for (n = 0; n < this.numBaseModel; ++n) {
            dArray[n] = doubleMatrix2D.get(n, 0);
        }
    }

    private static boolean allRatesAreZero(Parameter parameter) {
        for (int i = 0; i < parameter.getDimension(); ++i) {
            if (parameter.getParameterValue(i) == 0.0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void storeState() {
        System.arraycopy(this.baseStationaryDistribution, 0, this.storedBaseStationaryDistribution, 0, this.numBaseModel);
        this.storedStationaryDistributionKnown = this.stationaryDistributionKnown;
    }

    @Override
    protected void restoreState() {
        double[] dArray = this.baseStationaryDistribution;
        this.baseStationaryDistribution = this.storedBaseStationaryDistribution;
        this.storedBaseStationaryDistribution = dArray;
        this.stationaryDistributionKnown = this.storedStationaryDistributionKnown;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.switchingRates) {
            this.stationaryDistributionKnown = false;
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
    }

    @Override
    public int getFrequencyCount() {
        return this.totalFreqCount;
    }

    @Override
    public Parameter getFrequencyParameter() {
        throw new RuntimeException("Not implemented");
    }
}

