/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology.casetocase.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.epidemiology.casetocase.AbstractCase;
import dr.evomodel.epidemiology.casetocase.BranchMapModel;
import dr.evomodel.epidemiology.casetocase.CaseToCaseTreeLikelihood;
import dr.evomodel.epidemiology.casetocase.PartitionedTreeModel;
import dr.evomodel.operators.AbstractTreeOperator;
import dr.evomodel.operators.ExchangeOperator;
import dr.evomodel.operators.SubtreeSlideOperator;
import dr.evomodel.operators.WilsonBalding;
import dr.evomodel.tree.TreeModel;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptableMCMCOperator;
import dr.inference.operators.AdaptationMode;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class TransmissionTreeOperator
extends AbstractAdaptableOperator {
    private final CaseToCaseTreeLikelihood c2cLikelihood;
    private final AbstractTreeOperator innerOperator;
    public static final String TRANSMISSION_TREE_OPERATOR = "transmissionTreeOperator";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(CaseToCaseTreeLikelihood.class, "The transmission network likelihood element"), new ElementRule(AbstractTreeOperator.class, "A phylogenetic tree operator.")};

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            CaseToCaseTreeLikelihood caseToCaseTreeLikelihood = (CaseToCaseTreeLikelihood)xMLObject.getChild(CaseToCaseTreeLikelihood.class);
            AbstractTreeOperator abstractTreeOperator = (AbstractTreeOperator)xMLObject.getChild(AbstractTreeOperator.class);
            AdaptationMode adaptationMode = AdaptationMode.ADAPTATION_OFF;
            if (abstractTreeOperator instanceof AdaptableMCMCOperator) {
                adaptationMode = ((AdaptableMCMCOperator)((Object)abstractTreeOperator)).getMode();
            }
            return new TransmissionTreeOperator(caseToCaseTreeLikelihood, abstractTreeOperator, adaptationMode);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Performs a tree move then readjusts the transmission network in order to maintain its integrity.";
        }

        @Override
        public Class getReturnType() {
            return TransmissionTreeOperator.class;
        }

        @Override
        public String getParserName() {
            return TransmissionTreeOperator.TRANSMISSION_TREE_OPERATOR;
        }
    };

    public TransmissionTreeOperator(CaseToCaseTreeLikelihood caseToCaseTreeLikelihood, AbstractTreeOperator abstractTreeOperator, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.c2cLikelihood = caseToCaseTreeLikelihood;
        this.innerOperator = abstractTreeOperator;
        this.setWeight(this.innerOperator.getWeight());
        throw new RuntimeException("TransmissionTreeOperator only works on non-extended tree paintings");
    }

    public TransmissionTreeOperator(CaseToCaseTreeLikelihood caseToCaseTreeLikelihood, AbstractTreeOperator abstractTreeOperator) {
        this(caseToCaseTreeLikelihood, abstractTreeOperator, AdaptationMode.ADAPTATION_OFF);
    }

    @Override
    public double doOperation() {
        int n;
        PartitionedTreeModel partitionedTreeModel = this.c2cLikelihood.getTreeModel();
        BranchMapModel branchMapModel = this.c2cLikelihood.getBranchMap();
        AbstractCase[] abstractCaseArray = branchMapModel.getArrayCopy();
        int[] nArray = this.getParentsArray(partitionedTreeModel);
        double[] dArray = this.getHeightsArray(partitionedTreeModel);
        double d = this.innerOperator.doOperation();
        int[] nArray2 = this.getParentsArray(partitionedTreeModel);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < partitionedTreeModel.getNodeCount(); ++n) {
            if (nArray[n] == nArray2[n]) continue;
            arrayList.add(n);
        }
        if (arrayList.size() != 0) {
            if (this.innerOperator instanceof ExchangeOperator) {
                int n2;
                AbstractCase[] abstractCaseArray2 = new AbstractCase[2];
                AbstractCase[] abstractCaseArray3 = new AbstractCase[2];
                for (n2 = 0; n2 < 2; ++n2) {
                    abstractCaseArray2[n2] = branchMapModel.get((Integer)arrayList.get(n2));
                    abstractCaseArray3[n2] = branchMapModel.get(nArray[(Integer)arrayList.get(n2)]);
                }
                if (abstractCaseArray2[0] == abstractCaseArray3[0] || abstractCaseArray2[1] == abstractCaseArray3[1]) {
                    for (n2 = 0; n2 < 2; ++n2) {
                        this.paintUp(partitionedTreeModel, abstractCaseArray2[1 - n2], abstractCaseArray2[n2], branchMapModel, abstractCaseArray, partitionedTreeModel.getNode((Integer)arrayList.get(n2)).getNumber(), nArray2);
                    }
                }
            } else if (this.innerOperator instanceof SubtreeSlideOperator || this.innerOperator instanceof WilsonBalding) {
                n = -1;
                int n3 = -1;
                int n4 = -1;
                for (int i = 0; i < partitionedTreeModel.getNodeCount(); ++i) {
                    if (partitionedTreeModel.getNodeHeight(partitionedTreeModel.getNode(i)) == dArray[i]) continue;
                    n = i;
                    break;
                }
                Object object = arrayList.iterator();
                while (object.hasNext()) {
                    int n5 = (Integer)object.next();
                    if (n5 == n) continue;
                    if (partitionedTreeModel.getParent(partitionedTreeModel.getNode(n5)) == partitionedTreeModel.getNode(n)) {
                        n4 = n5;
                        continue;
                    }
                    n3 = n5;
                }
                if (n == -1 || n3 == -1 || n4 == -1) {
                    throw new RuntimeException("Failed to establish relationship between relocated node and others");
                }
                object = partitionedTreeModel.getNode(n);
                NodeRef nodeRef = partitionedTreeModel.getNode(n3);
                NodeRef nodeRef2 = partitionedTreeModel.getNode(n4);
                int n6 = -1;
                for (int i = 0; i < partitionedTreeModel.getChildCount((NodeRef)object); ++i) {
                    if (partitionedTreeModel.getChild((NodeRef)object, i) == nodeRef2) continue;
                    NodeRef nodeRef3 = partitionedTreeModel.getChild((NodeRef)object, i);
                    n6 = nodeRef3.getNumber();
                }
                if (branchMapModel.get(n6) != branchMapModel.get(n)) {
                    abstractCaseArray[n] = branchMapModel.get(n4);
                } else {
                    this.paintUp(partitionedTreeModel, branchMapModel.get(n), branchMapModel.get(n3), branchMapModel, abstractCaseArray, n3, nArray);
                    abstractCaseArray[n] = branchMapModel.get(n);
                    branchMapModel.setAll(abstractCaseArray, true);
                    this.paintUp(partitionedTreeModel, branchMapModel.get(n4), branchMapModel.get(n), branchMapModel, abstractCaseArray, n, nArray2);
                }
            } else {
                throw new UnsupportedOperationException("Operator class " + this.innerOperator.getOperatorName() + " not yet supported");
            }
        }
        branchMapModel.setAll(abstractCaseArray, true);
        this.c2cLikelihood.makeDirty();
        return d;
    }

    private void paintUp(TreeModel treeModel, AbstractCase abstractCase, AbstractCase abstractCase2, BranchMapModel branchMapModel, AbstractCase[] abstractCaseArray, int n, int[] nArray) {
        if (nArray[n] == -1) {
            return;
        }
        NodeRef nodeRef = treeModel.getNode(nArray[n]);
        while (nodeRef != null && branchMapModel.get(nodeRef.getNumber()) == abstractCase) {
            abstractCaseArray[nodeRef.getNumber()] = abstractCase2;
            nodeRef = nArray[nodeRef.getNumber()] == -1 ? null : treeModel.getNode(nArray[nodeRef.getNumber()]);
        }
    }

    private int[] getParentsArray(TreeModel treeModel) {
        int[] nArray = new int[treeModel.getNodeCount()];
        for (int i = 0; i < treeModel.getNodeCount(); ++i) {
            nArray[i] = treeModel.getNode(i) == treeModel.getRoot() ? -1 : treeModel.getParent(treeModel.getNode(i)).getNumber();
        }
        return nArray;
    }

    private double[] getHeightsArray(TreeModel treeModel) {
        double[] dArray = new double[treeModel.getNodeCount()];
        for (int i = 0; i < treeModel.getNodeCount(); ++i) {
            dArray[i] = treeModel.getNodeHeight(treeModel.getNode(i));
        }
        return dArray;
    }

    @Override
    public double getAdaptableParameterValue() {
        if (this.innerOperator instanceof AdaptableMCMCOperator) {
            return ((AdaptableMCMCOperator)((Object)this.innerOperator)).getAdaptableParameter();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        if (this.innerOperator instanceof AdaptableMCMCOperator) {
            ((AdaptableMCMCOperator)((Object)this.innerOperator)).setAdaptableParameter(d);
            return;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double getRawParameter() {
        if (this.innerOperator instanceof AdaptableMCMCOperator) {
            return ((AdaptableMCMCOperator)((Object)this.innerOperator)).getRawParameter();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getAdaptableParameterName() {
        if (this.innerOperator instanceof AdaptableMCMCOperator) {
            return ((AdaptableMCMCOperator)((Object)this.innerOperator)).getAdaptableParameterName();
        }
        return "";
    }

    @Override
    public String getOperatorName() {
        return TRANSMISSION_TREE_OPERATOR;
    }
}

