/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.ExponentialGrowth;
import dr.evolution.util.Units;

public class Expansion
extends ExponentialGrowth {
    private double N1 = 0.0;

    public Expansion(Units.Type type) {
        super(type);
    }

    public double getN1() {
        return this.N1;
    }

    public void setN1(double d) {
        this.N1 = d;
    }

    public void setProportion(double d) {
        this.N1 = this.getN0() * d;
    }

    @Override
    public double getDemographic(double d) {
        double d2 = this.getN0();
        double d3 = this.getN1();
        double d4 = this.getGrowthRate();
        if (d3 > d2) {
            throw new IllegalArgumentException("N0 must be greater than N1!");
        }
        return d3 + (d2 - d3) * Math.exp(-d4 * d);
    }

    @Override
    public double getIntensity(double d) {
        double d2 = this.getN0();
        double d3 = this.getN1();
        double d4 = d2 - d3;
        double d5 = this.getGrowthRate();
        return Math.log(d4 + d3 * Math.exp(d5 * d)) / (d5 * d3);
    }

    @Override
    public double getInverseIntensity(double d) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double getIntegral(double d, double d2) {
        double d3 = this.getIntensity(d2) - this.getIntensity(d);
        return d3;
    }

    @Override
    public int getNumArguments() {
        return 3;
    }

    @Override
    public String getArgumentName(int n) {
        switch (n) {
            case 0: {
                return "N0";
            }
            case 1: {
                return "r";
            }
            case 2: {
                return "N1";
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public double getArgument(int n) {
        switch (n) {
            case 0: {
                return this.getN0();
            }
            case 1: {
                return this.getGrowthRate();
            }
            case 2: {
                return this.getN1();
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public void setArgument(int n, double d) {
        switch (n) {
            case 0: {
                this.setN0(d);
                break;
            }
            case 1: {
                this.setGrowthRate(d);
                break;
            }
            case 2: {
                this.setN1(d);
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument " + n + " does not exist");
            }
        }
    }

    @Override
    public double getLowerBound(int n) {
        return 0.0;
    }

    @Override
    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }
}

