/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.factorAnalysis;

import dr.evomodel.continuous.FullyConjugateMultivariateTraitLikelihood;
import dr.evomodel.continuous.GaussianProcessFromTree;
import dr.inference.model.AdaptableSizeFastMatrixParameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.math.distributions.GammaDistribution;
import dr.math.distributions.NormalDistribution;

public class LFMSplitMergeOperator
extends AbstractAdaptableOperator {
    NormalDistribution drawDistribution;
    AdaptableSizeFastMatrixParameter factors;
    AdaptableSizeFastMatrixParameter sparseLoadings;
    AdaptableSizeFastMatrixParameter denseLoadings;
    AdaptableSizeFastMatrixParameter cutoffs;
    FullyConjugateMultivariateTraitLikelihood tree;
    GaussianProcessFromTree treeDraw;
    NormalDistribution standardNormal = new NormalDistribution(0.0, 1.0);
    GammaDistribution gamma = new GammaDistribution(1.0, 1.0);
    private String lastCall;
    final boolean upperTriangular = true;

    public LFMSplitMergeOperator(double d, double d2, AdaptableSizeFastMatrixParameter adaptableSizeFastMatrixParameter, AdaptableSizeFastMatrixParameter adaptableSizeFastMatrixParameter2, AdaptableSizeFastMatrixParameter adaptableSizeFastMatrixParameter3, AdaptableSizeFastMatrixParameter adaptableSizeFastMatrixParameter4, FullyConjugateMultivariateTraitLikelihood fullyConjugateMultivariateTraitLikelihood) {
        super(AdaptationMode.DEFAULT);
        GaussianProcessFromTree gaussianProcessFromTree;
        this.setWeight(d);
        this.drawDistribution = new NormalDistribution(0.0, Math.sqrt(d2));
        this.factors = adaptableSizeFastMatrixParameter;
        this.sparseLoadings = adaptableSizeFastMatrixParameter3;
        this.denseLoadings = adaptableSizeFastMatrixParameter2;
        this.cutoffs = adaptableSizeFastMatrixParameter4;
        this.tree = fullyConjugateMultivariateTraitLikelihood;
        this.treeDraw = gaussianProcessFromTree = new GaussianProcessFromTree(fullyConjugateMultivariateTraitLikelihood);
    }

    @Override
    public String getOperatorName() {
        return "Latent Factor Model Split-Merge Operator";
    }

    @Override
    public double doOperation() {
        double d;
        double d2 = MathUtils.nextDouble();
        double d3 = 0.0;
        if ((d2 < 0.5 || this.denseLoadings.getColumnDimension() == this.denseLoadings.getMaxColumnDimension()) && this.denseLoadings.getColumnDimension() != 1) {
            this.lastCall = "decrement";
            if (this.denseLoadings.getColumnDimension() == 2) {
                d3 += Math.log(2.0);
            }
            if (this.denseLoadings.getColumnDimension() == this.denseLoadings.getMaxColumnDimension()) {
                d3 += -Math.log(2.0);
            }
            d = this.decrement();
        } else {
            this.lastCall = "increment";
            if (this.denseLoadings.getColumnDimension() == 1) {
                d3 += -Math.log(2.0);
            }
            if (this.denseLoadings.getColumnDimension() == this.denseLoadings.getMaxColumnDimension() - 1) {
                d3 += Math.log(2.0);
            }
            d = this.increment();
        }
        this.denseLoadings.fireParameterChangedEvent();
        this.sparseLoadings.fireParameterChangedEvent();
        this.cutoffs.fireParameterChangedEvent();
        this.factors.fireParameterChangedEvent();
        return d + d3;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return 0.0;
    }

    @Override
    public void setAdaptableParameterValue(double d) {
    }

    @Override
    public double getRawParameter() {
        return 0.0;
    }

    @Override
    public String getAdaptableParameterName() {
        return "";
    }

    private double increment() {
        double d = 0.0;
        int n = MathUtils.nextInt(this.denseLoadings.getColumnDimension());
        int n2 = this.denseLoadings.getColumnDimension();
        this.denseLoadings.setColumnDimension(this.denseLoadings.getColumnDimension() + 1);
        this.sparseLoadings.setColumnDimension(this.sparseLoadings.getColumnDimension() + 1);
        this.cutoffs.setColumnDimension(this.cutoffs.getColumnDimension() + 1);
        for (int i = 0; i < this.denseLoadings.getRowDimension(); ++i) {
            if (i >= n2) {
                if (this.sparseLoadings.getParameterValue(i, n) == 0.0) {
                    d += this.sparseIncrement(i, n2);
                    continue;
                }
                int n3 = MathUtils.nextInt(3);
                n3 = 2;
                if (n3 == 0) {
                    d += this.sparseIncrement(i, n2);
                    continue;
                }
                if (n3 == 1) {
                    this.sparseLoadings.setParameterValueQuietly(i, n2, this.sparseLoadings.getParameterValue(i, n));
                    this.cutoffs.setParameterValueQuietly(i, n2, this.cutoffs.getParameterValue(i, n));
                    this.denseLoadings.setParameterValueQuietly(i, n2, this.denseLoadings.getParameterValue(i, n));
                    d += this.sparseIncrement(i, n);
                    continue;
                }
                d += -Math.log(Math.pow(this.denseLoadings.getParameterValue(i, n), 2.0));
                this.sparseLoadings.setParameterValueQuietly(i, n2, 1.0);
                double d2 = (Double)this.drawDistribution.nextRandom();
                double d3 = this.denseLoadings.getParameterValue(i, n) + d2;
                double d4 = this.denseLoadings.getParameterValue(i, n) - d2;
                this.denseLoadings.setParameterValueQuietly(i, n2, d3);
                this.denseLoadings.setParameterValueQuietly(i, n, d4);
                d += -this.drawDistribution.logPdf(d2);
                d += Math.log(2.0);
                double d5 = MathUtils.nextDouble() * Math.pow(d3, 2.0);
                double d6 = MathUtils.nextDouble() * Math.pow(d4, 2.0);
                d += Math.log(Math.pow(d3, 2.0));
                d += Math.log(Math.pow(d4, 2.0));
                this.cutoffs.setParameterValueQuietly(i, n2, d5);
                this.cutoffs.setParameterValueQuietly(i, n, d6);
                continue;
            }
            double d7 = this.gamma.nextGamma();
            d += -this.gamma.logPdf(d7);
            this.cutoffs.setParameterValueQuietly(i, n2, d7);
        }
        return d;
    }

    double sparseIncrement(int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        this.sparseLoadings.setParameterValueQuietly(n, n2, 0.0);
        d = (Double)this.standardNormal.nextRandom();
        this.denseLoadings.setParameterValueQuietly(n, n2, d);
        d3 += -this.standardNormal.logPdf(d);
        d2 = MathUtils.nextDouble() * Math.pow(d, 2.0);
        this.cutoffs.setParameterValueQuietly(n, n2, d2);
        return d3 += Math.log(Math.pow(d, 2.0));
    }

    private double decrement() {
        double d = 0.0;
        int n = MathUtils.nextInt(this.denseLoadings.getColumnDimension() - 1);
        int n2 = this.denseLoadings.getColumnDimension() - 1;
        for (int i = 0; i < this.denseLoadings.getRowDimension(); ++i) {
            if (i >= n2) {
                if (this.sparseLoadings.getParameterValue(i, n) == 1.0 && this.sparseLoadings.getParameterValue(i, n2) == 1.0) {
                    d += -Math.log(Math.pow(this.denseLoadings.getParameterValue(i, n), 2.0));
                    d += -Math.log(Math.pow(this.denseLoadings.getParameterValue(i, n2), 2.0));
                    d += this.drawDistribution.logPdf((this.denseLoadings.getParameterValue(i, n2) - this.denseLoadings.getParameterValue(i, n)) / 2.0);
                    d += -Math.log(2.0);
                    double d2 = (this.denseLoadings.getParameterValue(i, n) + this.denseLoadings.getParameterValue(i, n2)) / 2.0;
                    this.denseLoadings.setParameterValueQuietly(i, n, d2);
                    double d3 = MathUtils.nextDouble() * Math.pow(d2, 2.0);
                    this.cutoffs.setParameterValueQuietly(i, n, d3);
                    continue;
                }
                if (this.sparseLoadings.getParameterValue(i, n) == 1.0 && this.sparseLoadings.getParameterValue(i, n2) == 0.0) {
                    d += this.standardNormal.logPdf(this.denseLoadings.getParameterValue(i, n2));
                    d += -Math.log(Math.pow(this.denseLoadings.getParameterValue(i, n2), 2.0));
                    continue;
                }
                if (this.sparseLoadings.getParameterValue(i, n) == 0.0 && this.sparseLoadings.getParameterValue(i, n2) == 1.0) {
                    d += this.standardNormal.logPdf(this.denseLoadings.getParameterValue(i, n));
                    d += -Math.log(Math.pow(this.denseLoadings.getParameterValue(i, n), 2.0));
                    this.denseLoadings.setParameterValueQuietly(i, n, this.denseLoadings.getParameterValue(i, n2));
                    this.cutoffs.setParameterValueQuietly(i, n, this.cutoffs.getParameterValue(i, n2));
                    this.sparseLoadings.setParameterValueQuietly(i, n, 1.0);
                    continue;
                }
                d += this.standardNormal.logPdf(this.denseLoadings.getParameterValue(i, n2));
                d += -Math.log(Math.pow(this.denseLoadings.getParameterValue(i, n2), 2.0));
                continue;
            }
            d += this.gamma.logPdf(this.cutoffs.getParameterValue(i, n2));
        }
        this.denseLoadings.setColumnDimension(this.denseLoadings.getColumnDimension() - 1);
        this.sparseLoadings.setColumnDimension(this.sparseLoadings.getColumnDimension() - 1);
        this.cutoffs.setColumnDimension(this.cutoffs.getColumnDimension() - 1);
        return d;
    }
}

