/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.markovjumps;

import dr.inference.markovjumps.MarkovJumpsCore;
import dr.math.GammaFunction;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SubordinatedProcess {
    private final List<double[]> dtmcCache;
    private final double poissonRate;
    private final int stateCount;
    private final double[] tmp;
    private double cachedXForExp = Double.NaN;
    private double cachedExpValue;
    private static final boolean DEBUG = false;
    private static final boolean THROW_EXCEPTION = true;
    private double[] Q;

    public SubordinatedProcess(double[] dArray, int n) {
        this.stateCount = n;
        this.poissonRate = this.getMaxRate(dArray, n);
        this.dtmcCache = new ArrayList<double[]>();
        this.dtmcCache.add(this.makeIndentityMatrx(n));
        this.dtmcCache.add(this.constructDtmcMatrix(dArray, n));
        this.tmp = new double[n];
        this.Q = dArray;
    }

    public double getPoissonRate() {
        return this.poissonRate;
    }

    private double getCachedExp(double d) {
        if (d != this.cachedXForExp) {
            this.cachedXForExp = d;
            this.cachedExpValue = Math.exp(d);
        }
        return this.cachedExpValue;
    }

    public double[] getDtmcProbabilities(int n) {
        if (n > this.dtmcCache.size() - 1) {
            double[] dArray = this.dtmcCache.get(1);
            for (int i = this.dtmcCache.size() - 1; i <= n; ++i) {
                double[] dArray2 = this.dtmcCache.get(i);
                double[] dArray3 = new double[this.stateCount * this.stateCount];
                MarkovJumpsCore.matrixMultiply(dArray2, dArray, this.stateCount, dArray3);
                this.dtmcCache.add(dArray3);
            }
        }
        return this.dtmcCache.get(n);
    }

    private double getMaxRate(double[] dArray, int n) {
        double d = -dArray[0];
        for (int i = 1; i < n; ++i) {
            double d2 = -dArray[i * n + i];
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    private double[] constructDtmcMatrix(double[] dArray, int n) {
        double[] dArray2 = new double[n * n];
        double d = this.getMaxRate(dArray, n);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[n2] = dArray[n2] / d;
                if (i == j) {
                    int n3 = n2;
                    dArray2[n3] = dArray2[n3] + 1.0;
                }
                ++n2;
            }
        }
        return dArray2;
    }

    public double[] drawTransitionTimes(double d, int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d * MathUtils.nextDouble();
        }
        if (dArray.length > 1) {
            Arrays.sort(dArray);
        }
        return dArray;
    }

    public int drawNextChainState(int n, int n2, int n3, int n4) {
        this.computePdfNextChainState(n, n2, n3, n4, this.tmp);
        return MathUtils.randomChoicePDF(this.tmp);
    }

    public void computePdfNextChainState(int n, int n2, int n3, int n4, double[] dArray) {
        double[] dArray2 = this.getDtmcProbabilities(1);
        double[] dArray3 = this.getDtmcProbabilities(n3 - n4);
        for (int i = 0; i < this.stateCount; ++i) {
            dArray[i] = dArray2[n * this.stateCount + i] * dArray3[i * this.stateCount + n2];
        }
    }

    public int drawNumberOfChanges(int n, int n2, double d, double d2) throws Exception {
        return this.drawNumberOfChanges(n, n2, d, d2, MathUtils.nextDouble());
    }

    public int drawNumberOfChanges(int n, int n2, double d, double d2, double d3) throws Exception {
        double[] dArray;
        int n3 = -1;
        double d4 = this.getPoissonRate() * d;
        double d5 = this.getCachedExp(-d4);
        double d6 = 1.0;
        int n4 = n * this.stateCount + n2;
        int n5 = 1000;
        for (double d7 = 0.0; d3 >= d7; d7 += d5 * d6 * dArray[n4] / d2) {
            dArray = this.getDtmcProbabilities(++n3);
            if (n3 > 0) {
                d6 *= d4;
            }
            if (n3 <= 1) continue;
            d6 /= (double)n3;
            if (n3 != n5) continue;
            throw new Exception();
        }
        return n3;
    }

    public double[] computePDFDirectly(int n, int n2, double d, double d2, int n3) {
        double[] dArray = new double[n3];
        double d3 = Math.log(this.getPoissonRate()) + Math.log(d);
        double d4 = Math.log(d2);
        for (int i = 0; i < n3; ++i) {
            double[] dArray2 = this.getDtmcProbabilities(i);
            dArray[i] = Math.exp(-this.getPoissonRate() * d + (double)i * d3 - GammaFunction.lnGamma(i + 1) + Math.log(dArray2[n * this.stateCount + n2]) - d4);
        }
        return dArray;
    }

    private double[] makeIndentityMatrx(int n) {
        double[] dArray = new double[n * n];
        for (int i = 0; i < n; ++i) {
            dArray[i * n + i] = 1.0;
        }
        return dArray;
    }

    public class Exception
    extends java.lang.Exception {
    }
}

