/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.loggers;

import dr.inference.loggers.LogColumn;
import java.text.DecimalFormat;

public abstract class NumberColumn
extends LogColumn.Abstract {
    private int sf = -1;
    private int dp = -1;
    private double upperCutoff;
    private double[] cutoffTable;
    private final DecimalFormat decimalFormat = new DecimalFormat();
    private DecimalFormat scientificFormat = null;

    public NumberColumn(String string) {
        super(string);
        this.decimalFormat.setGroupingUsed(false);
    }

    public NumberColumn(String string, int n) {
        this(string);
        this.setSignificantFigures(n);
    }

    public void setSignificantFigures(int n) {
        this.sf = n;
        this.dp = -1;
        this.upperCutoff = Math.pow(10.0, n - 1);
        this.cutoffTable = new double[n];
        long l = 10L;
        for (int i = 0; i < this.cutoffTable.length; ++i) {
            this.cutoffTable[i] = l;
            l *= 10L;
        }
        this.decimalFormat.setGroupingUsed(false);
        this.decimalFormat.setMinimumIntegerDigits(1);
        this.decimalFormat.setMaximumFractionDigits(n - 1);
        this.decimalFormat.setMinimumFractionDigits(n - 1);
        this.scientificFormat = new DecimalFormat(this.getPattern(n));
    }

    public int getSignificantFigures() {
        return this.sf;
    }

    public void setDecimalPlaces(int n) {
        this.dp = n;
        this.sf = -1;
    }

    public int getDecimalPlaces() {
        return this.dp;
    }

    public String formatValue(double d) {
        if (this.dp < 0 && this.sf < 0) {
            return Double.toString(d);
        }
        int n = 0;
        if (this.dp < 0) {
            double d2 = Math.abs(d);
            if (d2 > this.upperCutoff || d2 < 0.1) {
                return this.scientificFormat.format(d);
            }
            n = this.getNumFractionDigits(d);
        } else {
            n = this.dp;
        }
        this.decimalFormat.setMaximumFractionDigits(n);
        this.decimalFormat.setMinimumFractionDigits(n);
        return this.decimalFormat.format(d);
    }

    @Override
    protected String getFormattedValue() {
        return this.formatValue(this.getDoubleValue());
    }

    private int getNumFractionDigits(double d) {
        d = Math.abs(d);
        for (int i = 0; i < this.cutoffTable.length; ++i) {
            if (!(d < this.cutoffTable[i])) continue;
            return this.sf - i - 1;
        }
        return this.sf - 1;
    }

    private String getPattern(int n) {
        String string = "0.";
        for (int i = 0; i < n - 1; ++i) {
            string = string + "#";
        }
        string = string + "E0";
        return string;
    }

    public abstract double getDoubleValue();
}

