/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.AbstractDistributionLikelihood;
import dr.inference.distribution.ParametricDistributionModel;
import dr.math.distributions.Distribution;
import dr.util.Attribute;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DistributionLikelihood
extends AbstractDistributionLikelihood {
    public static final boolean DEBUG = false;
    public static final String DISTRIBUTION_LIKELIHOOD = "distributionLikelihood";
    private int from = -1;
    private int to = Integer.MAX_VALUE;
    private final boolean evaluateEarly;
    protected Distribution distribution;
    private final double offset;
    private final double scale;

    public DistributionLikelihood(Distribution distribution) {
        this(distribution, 0.0, false, 1.0);
    }

    public DistributionLikelihood(Distribution distribution, double d) {
        this(distribution, d, d > 0.0, 1.0);
    }

    public DistributionLikelihood(Distribution distribution, double d, double d2) {
        this(distribution, d, d > 0.0, d2);
    }

    public DistributionLikelihood(Distribution distribution, boolean bl) {
        this(distribution, 0.0, bl, 1.0);
    }

    public DistributionLikelihood(Distribution distribution, double d, boolean bl, double d2) {
        super(null);
        this.distribution = distribution;
        this.offset = d;
        this.evaluateEarly = bl;
        this.scale = d2;
    }

    public DistributionLikelihood(ParametricDistributionModel parametricDistributionModel) {
        super(parametricDistributionModel);
        this.distribution = parametricDistributionModel;
        this.offset = 0.0;
        this.evaluateEarly = false;
        this.scale = 1.0;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public void setRange(int n, int n2) {
        this.from = n;
        this.to = n2;
    }

    @Override
    public double calculateLogLikelihood() {
        double d = 0.0;
        int n = 0;
        for (Attribute attribute : this.dataList) {
            double[] dArray = (double[])attribute.getAttributeValue();
            for (int i = Math.max(0, this.from); i < Math.min(dArray.length, this.to); ++i) {
                double d2 = dArray[i] - this.offset;
                if (this.offset > 0.0 && d2 < 0.0) {
                    return Double.NEGATIVE_INFINITY;
                }
                d += this.getLogPDF(d2, n);
                ++n;
            }
        }
        return d;
    }

    protected double getLogPDF(double d, int n) {
        return this.distribution.logPdf(d / this.scale) - Math.log(this.scale);
    }

    @Override
    public boolean evaluateEarly() {
        return this.evaluateEarly;
    }

    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented yet!");
    }

    @Override
    public String prettyName() {
        String string = this.distribution.getClass().getName();
        String[] stringArray = string.split("\\.");
        if ((string = stringArray[stringArray.length - 1]).endsWith("Distribution")) {
            string = string.substring(0, string.length() - "Distribution".length());
        }
        string = string + '(';
        for (Attribute attribute : this.dataList) {
            String string2 = attribute.getAttributeName();
            if (string2 == null) {
                string2 = "?";
            }
            string = string + string2 + ',';
        }
        string = string.substring(0, string.length() - 1) + ')';
        return string;
    }
}

