/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.transmission;

import dr.evolution.coalescent.ConstantPopulation;
import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.evoxml.util.XMLUnits;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;

public class TransmissionDemographicModel
extends DemographicModel {
    public static String TRANSMISSION_MODEL = "transmissionModel";
    public static String CONSTANT = "constant";
    public static String EXPONENTIAL = "exponential";
    public static String LOGISTIC = "logistic";
    public static String POPULATION_SIZE = "populationSize";
    public static String ANCESTRAL_PROPORTION = "ancestralProportion";
    public static String GROWTH_RATE = "growthRate";
    public static String DOUBLING_TIME = "doublingTime";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{XMLUnits.UNITS_RULE, new XORRule(new ElementRule(CONSTANT, new XMLSyntaxRule[]{new ElementRule(POPULATION_SIZE, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter represents the carrying capacity (maximum population size). If the shape is very large then the current day population size will be very close to the carrying capacity.")}), new XORRule(new ElementRule(EXPONENTIAL, new XMLSyntaxRule[]{new XORRule(new ElementRule(GROWTH_RATE, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter determines the rate of growth during the exponential phase. See exponentialGrowth for details."), new ElementRule(DOUBLING_TIME, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter determines the doubling time at peak growth rate.")), new ElementRule(ANCESTRAL_PROPORTION, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter determines the populaation size at transmission.")}), new ElementRule(LOGISTIC, new XMLSyntaxRule[]{new ElementRule(POPULATION_SIZE, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter represents the carrying capacity (maximum population size). If the shape is very large then the current day population size will be very close to the carrying capacity."), new XORRule(new ElementRule(GROWTH_RATE, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter determines the rate of growth during the exponential phase. See exponentialGrowth for details."), new ElementRule(DOUBLING_TIME, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter determines the doubling time at peak growth rate.")), new ElementRule(ANCESTRAL_PROPORTION, new XMLSyntaxRule[]{new ElementRule(Parameter.class)}, "This parameter determines the populaation size at transmission.")})))};

        @Override
        public String getParserName() {
            return TRANSMISSION_MODEL;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Units.Type type = XMLUnits.Utils.getUnitsAttr(xMLObject);
            int n = 0;
            Parameter parameter = null;
            Parameter parameter2 = null;
            Parameter parameter3 = null;
            Parameter parameter4 = null;
            if (xMLObject.hasChildNamed(CONSTANT)) {
                XMLObject xMLObject2 = xMLObject.getChild(CONSTANT);
                parameter = (Parameter)xMLObject2.getElementFirstChild(POPULATION_SIZE);
                n = 0;
            } else if (xMLObject.hasChildNamed(EXPONENTIAL)) {
                XMLObject xMLObject3 = xMLObject.getChild(EXPONENTIAL);
                parameter2 = (Parameter)xMLObject3.getElementFirstChild(ANCESTRAL_PROPORTION);
                if (xMLObject3.hasChildNamed(GROWTH_RATE)) {
                    parameter3 = (Parameter)xMLObject3.getElementFirstChild(GROWTH_RATE);
                } else {
                    parameter4 = (Parameter)xMLObject3.getElementFirstChild(DOUBLING_TIME);
                }
                n = 1;
            } else if (xMLObject.hasChildNamed(LOGISTIC)) {
                XMLObject xMLObject4 = xMLObject.getChild(LOGISTIC);
                parameter = (Parameter)xMLObject4.getElementFirstChild(POPULATION_SIZE);
                parameter2 = (Parameter)xMLObject4.getElementFirstChild(ANCESTRAL_PROPORTION);
                if (xMLObject4.hasChildNamed(GROWTH_RATE)) {
                    parameter3 = (Parameter)xMLObject4.getElementFirstChild(GROWTH_RATE);
                } else {
                    parameter4 = (Parameter)xMLObject4.getElementFirstChild(DOUBLING_TIME);
                }
                n = 2;
            }
            return new TransmissionDemographicModel(n, parameter, parameter2, parameter3, parameter4, type);
        }

        @Override
        public String getParserDescription() {
            return "A SiteModel that has a gamma distributed rates across sites";
        }

        @Override
        public Class getReturnType() {
            return TransmissionDemographicModel.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    Parameter N0Parameter = null;
    Parameter N1Parameter = null;
    Parameter growthRateParameter = null;
    Parameter doublingTimeParameter = null;
    DemographicFunction hostDemographic = null;
    int model = 0;

    public TransmissionDemographicModel(int n, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Units.Type type) {
        this(TRANSMISSION_MODEL, n, parameter, parameter2, parameter3, parameter4, type);
    }

    public TransmissionDemographicModel(String string, int n, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Units.Type type) {
        super(string);
        this.model = n;
        if (n == 0) {
            this.hostDemographic = new ConstantPopulation(type);
        } else if (n == 1) {
            this.hostDemographic = new TransmissionExponentialGrowth(type);
        } else if (n == 2) {
            this.hostDemographic = new TransmissionLogisticGrowth(type);
        }
        if (parameter != null) {
            this.N0Parameter = parameter;
            this.addVariable(parameter);
            parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        }
        if (parameter2 != null) {
            this.N1Parameter = parameter2;
            this.addVariable(parameter2);
            parameter2.addBounds(new Parameter.DefaultBounds(1.0, 0.0, 1));
        }
        if (parameter3 != null) {
            this.growthRateParameter = parameter3;
            this.addVariable(parameter3);
            parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        }
        if (parameter4 != null) {
            this.doublingTimeParameter = parameter4;
            this.addVariable(parameter4);
            parameter4.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        }
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        throw new RuntimeException("getDemographicFunction not used for TransmissionDemographicModel");
    }

    protected int getIndexFromHost(int n) {
        return 0;
    }

    public DemographicFunction getDemographicFunction(double d, double d2, int n) {
        int n2 = this.getIndexFromHost(n);
        if (this.model == 0) {
            double d3 = this.N0Parameter.getParameterValue(n2);
            ((ConstantPopulation)this.hostDemographic).setN0(d3);
        } else if (this.model == 1) {
            double d4 = this.N1Parameter.getParameterValue(n2);
            ((TransmissionDemographicFunction)this.hostDemographic).setTransmissionTime(d);
            ((TransmissionDemographicFunction)this.hostDemographic).setDonorSize(d2);
            ((TransmissionDemographicFunction)this.hostDemographic).setBottleNeckProportion(d4);
            if (this.growthRateParameter != null) {
                double d5 = this.growthRateParameter.getParameterValue(n2);
                ((TransmissionExponentialGrowth)this.hostDemographic).setGrowthRate(d5);
            } else {
                double d6 = this.doublingTimeParameter.getParameterValue(n2);
                ((TransmissionExponentialGrowth)this.hostDemographic).setDoublingTime(d6);
            }
        } else if (this.model == 2) {
            ((TransmissionDemographicFunction)this.hostDemographic).setTransmissionTime(d);
            ((TransmissionDemographicFunction)this.hostDemographic).setDonorSize(d2);
            double d7 = this.N0Parameter.getParameterValue(n2);
            ((TransmissionLogisticGrowth)this.hostDemographic).setN0(d7);
            double d8 = this.N1Parameter.getParameterValue(n2);
            ((TransmissionDemographicFunction)this.hostDemographic).setBottleNeckProportion(d8);
            if (this.growthRateParameter != null) {
                double d9 = this.growthRateParameter.getParameterValue(n2);
                ((TransmissionLogisticGrowth)this.hostDemographic).setGrowthRate(d9);
            } else {
                double d10 = this.doublingTimeParameter.getParameterValue(n2);
                ((TransmissionLogisticGrowth)this.hostDemographic).setDoublingTime(d10);
            }
        }
        return this.hostDemographic;
    }

    private class TransmissionLogisticGrowth
    extends TransmissionDemographicFunction {
        private double N0;
        private double r;
        private double N1;

        public TransmissionLogisticGrowth(Units.Type type) {
            super(type);
        }

        public void setGrowthRate(double d) {
            this.r = d;
        }

        public void setDoublingTime(double d) {
            this.setGrowthRate(Math.log(2.0) / d);
        }

        @Override
        public void setBottleNeckProportion(double d) {
            this.N1 = d * this.donorSize;
        }

        public void setN0(double d) {
            this.N0 = d;
        }

        public double getN0() {
            return this.N0;
        }

        @Override
        public double getDemographic(double d) {
            double d2 = Math.exp(-this.r * (d - this.transmissionTime - Math.log(1.0 / (this.N0 / this.N1 - 1.0)) / this.r));
            return this.N0 * d2 / (1.0 + d2);
        }

        @Override
        public double getIntegral(double d, double d2) {
            double d3 = d2 - d;
            double d4 = d - this.transmissionTime - Math.log(1.0 / (this.N0 / this.N1 - 1.0)) / this.r;
            double d5 = Math.exp(-this.r * d4);
            double d6 = Math.exp(-this.r * d3);
            double d7 = d3 / this.N0 + (1.0 - d6) / (this.N0 * d5 * this.r * d6);
            return d7;
        }

        @Override
        public double getIntensity(double d) {
            throw new RuntimeException("Function not used");
        }

        @Override
        public double getInverseIntensity(double d) {
            throw new RuntimeException("Function not used");
        }

        @Override
        public int getNumArguments() {
            throw new RuntimeException("Function not used");
        }

        @Override
        public String getArgumentName(int n) {
            throw new RuntimeException("Function not used");
        }

        @Override
        public double getArgument(int n) {
            throw new RuntimeException("Function not used");
        }

        @Override
        public void setArgument(int n, double d) {
            throw new RuntimeException("Function not used");
        }

        @Override
        public double getLowerBound(int n) {
            throw new RuntimeException("Function not used");
        }

        @Override
        public double getUpperBound(int n) {
            throw new RuntimeException("Function not used");
        }

        public DemographicFunction getCopy() {
            TransmissionLogisticGrowth transmissionLogisticGrowth = new TransmissionLogisticGrowth(this.getUnits());
            transmissionLogisticGrowth.N0 = this.N0;
            transmissionLogisticGrowth.r = this.r;
            transmissionLogisticGrowth.N1 = this.N1;
            transmissionLogisticGrowth.transmissionTime = this.transmissionTime;
            transmissionLogisticGrowth.donorSize = this.donorSize;
            return transmissionLogisticGrowth;
        }
    }

    private class TransmissionExponentialGrowth
    extends TransmissionDemographicFunction {
        private double r;
        private double N1;

        public TransmissionExponentialGrowth(Units.Type type) {
            super(type);
        }

        public void setGrowthRate(double d) {
            this.r = d;
        }

        public void setDoublingTime(double d) {
            this.setGrowthRate(Math.log(2.0) / d);
        }

        @Override
        public void setBottleNeckProportion(double d) {
            this.N1 = d * this.donorSize;
        }

        @Override
        public double getDemographic(double d) {
            return this.N1 * Math.exp(-this.r * (d - this.transmissionTime));
        }

        @Override
        public double getIntegral(double d, double d2) {
            double d3 = d - this.transmissionTime;
            double d4 = d2 - this.transmissionTime;
            double d5 = (Math.exp(d4 * this.r) - 1.0) / this.N1 / this.r - (Math.exp(d3 * this.r) - 1.0) / this.N1 / this.r;
            return d5;
        }

        @Override
        public double getIntensity(double d) {
            throw new RuntimeException("Function not used");
        }

        @Override
        public double getInverseIntensity(double d) {
            throw new RuntimeException("Function not used");
        }

        @Override
        public int getNumArguments() {
            throw new RuntimeException("Function not used");
        }

        @Override
        public String getArgumentName(int n) {
            throw new RuntimeException("Function not used");
        }

        @Override
        public double getArgument(int n) {
            throw new RuntimeException("Function not used");
        }

        @Override
        public void setArgument(int n, double d) {
            throw new RuntimeException("Function not used");
        }

        @Override
        public double getLowerBound(int n) {
            throw new RuntimeException("Function not used");
        }

        @Override
        public double getUpperBound(int n) {
            throw new RuntimeException("Function not used");
        }

        public DemographicFunction getCopy() {
            TransmissionExponentialGrowth transmissionExponentialGrowth = new TransmissionExponentialGrowth(this.getUnits());
            transmissionExponentialGrowth.r = this.r;
            transmissionExponentialGrowth.N1 = this.N1;
            transmissionExponentialGrowth.transmissionTime = this.transmissionTime;
            transmissionExponentialGrowth.donorSize = this.donorSize;
            return transmissionExponentialGrowth;
        }
    }

    private abstract class TransmissionDemographicFunction
    extends DemographicFunction.Abstract {
        protected double transmissionTime;
        protected double donorSize;

        public TransmissionDemographicFunction(Units.Type type) {
            super(type);
        }

        public void setDonorSize(double d) {
            this.donorSize = d;
        }

        public void setTransmissionTime(double d) {
            this.transmissionTime = d;
        }

        public abstract void setBottleNeckProportion(double var1);
    }
}

