/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.branchratemodel.ArbitraryBranchRates;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.tree.TreeParameterModel;
import dr.evomodel.treedatalikelihood.SimulationTreeTraversal;
import dr.evomodel.treedatalikelihood.preorder.LocalBranchRateDelegate;
import dr.evomodelxml.branchratemodel.LocalBranchRatesParser;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.math.matrixAlgebra.Vector;
import dr.xml.Reportable;

@Deprecated
public class LocalBranchRates
extends ArbitraryBranchRates
implements Reportable {
    private TreeModel tree;
    private TreeParameterModel ratesMultiplier;
    private Parameter multiplierParameter;
    private TreeParameterModel branchRates;
    private Parameter branchRateParameter;
    private double normalizingConstant;
    private LocalBranchRateDelegate branchRateDelegate;
    private final ArbitraryBranchRates.BranchRateTransform transform;
    private final SimulationTreeTraversal treeTraversalDelegate;
    private final int[] operations;

    public LocalBranchRates(TreeModel treeModel, Parameter parameter, ArbitraryBranchRates.BranchRateTransform branchRateTransform) {
        this(LocalBranchRatesParser.SHRINKAGE_BRANCH_RATES, treeModel, parameter, branchRateTransform);
    }

    public LocalBranchRates(String string, TreeModel treeModel, Parameter parameter, ArbitraryBranchRates.BranchRateTransform branchRateTransform) {
        super(string, treeModel, parameter, new ArbitraryBranchRates.BranchRateTransform.None(), false);
        this.tree = treeModel;
        this.multiplierParameter = parameter;
        this.ratesMultiplier = new TreeParameterModel(treeModel, this.multiplierParameter, false, TreeTrait.Intent.BRANCH);
        this.branchRateParameter = new Parameter.Default(treeModel.getNodeCount());
        this.branchRates = new TreeParameterModel(treeModel, this.branchRateParameter, true, TreeTrait.Intent.NODE);
        this.branchRateDelegate = new LocalBranchRateDelegate(LocalBranchRatesParser.SHRINKAGE_BRANCH_RATES, this.ratesMultiplier, this.branchRates);
        this.transform = branchRateTransform;
        this.treeTraversalDelegate = new SimulationTreeTraversal(treeModel, this, this.branchRateDelegate.getOptimalTraversalType());
        this.operations = new int[treeModel.getNodeCount() * this.branchRateDelegate.getSingleOperationSize()];
        this.updateBranchRates();
        this.addModel(this.ratesMultiplier);
        if (branchRateTransform instanceof Model) {
            this.addModel((Model)((Object)branchRateTransform));
        }
        if (!(branchRateTransform instanceof ArbitraryBranchRates.BranchRateTransform.None)) {
            throw new RuntimeException("Only tested without transformation.");
        }
    }

    private void simulateTraits(NodeRef nodeRef) {
        if (nodeRef == null) {
            this.treeTraversalDelegate.updateAllNodes();
        } else {
            this.treeTraversalDelegate.updateAllNodes();
        }
        this.treeTraversalDelegate.dispatchTreeTraversalCollectBranchAndNodeOperations();
        int n = this.branchRateDelegate.vectorizeNodeOperations(this.treeTraversalDelegate.getNodeOperations(), this.operations);
        NodeRef nodeRef2 = this.tree.getRoot();
        this.branchRateDelegate.simulate(this.operations, n, nodeRef2.getNumber());
        this.treeTraversalDelegate.setAllNodesUpdated();
    }

    private void updateNormalizingConstant() {
        double d = this.getTotalBranchLength();
        double d2 = this.getTotalRateBranchLengthProduct();
        this.normalizingConstant = d / d2;
    }

    private double getTotalBranchLength() {
        double d = 0.0;
        for (int i = 0; i < this.tree.getNodeCount(); ++i) {
            NodeRef nodeRef = this.tree.getNode(i);
            if (this.tree.isRoot(nodeRef)) continue;
            d += this.tree.getBranchLength(nodeRef);
        }
        return d;
    }

    private double getTotalRateBranchLengthProduct() {
        double d = 0.0;
        for (int i = 0; i < this.tree.getNodeCount(); ++i) {
            NodeRef nodeRef = this.tree.getNode(i);
            if (this.tree.isRoot(nodeRef)) continue;
            d += this.tree.getBranchLength(nodeRef) * this.ratesMultiplier.getNodeValue(this.tree, nodeRef);
        }
        return d;
    }

    private void updateBranchRates() {
        this.simulateTraits(null);
        this.updateNormalizingConstant();
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.ratesMultiplier) {
            this.fireModelChanged();
            this.updateBranchRates();
        }
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        return this.transform.transform(this.branchRates.getNodeValue(tree, nodeRef), tree, nodeRef);
    }

    @Override
    public void setBranchRate(Tree tree, NodeRef nodeRef, double d) {
        throw new RuntimeException("This function should not be called.");
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Local branch rates:\n").append(new Vector(this.branchRateParameter.getParameterValues()));
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    @Override
    public double getBranchRateDifferential(Tree tree, NodeRef nodeRef) {
        double d = this.ratesMultiplier.getNodeValue(tree, nodeRef);
        return this.branchRates.getNodeValue(tree, nodeRef) / d;
    }

    @Override
    public double getBranchRateSecondDifferential(Tree tree, NodeRef nodeRef) {
        throw new RuntimeException("Not yet implemented.");
    }
}

