% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliabilityMultiBayes.R
\name{bomegas}
\alias{bomegas}
\title{Estimate reliability estimates for multidimensional scales in the Bayesian framework}
\usage{
bomegas(
  data,
  n.factors,
  model = "balanced",
  n.iter = 2000,
  n.burnin = 200,
  n.chains = 3,
  thin = 1,
  interval = 0.95,
  missing = "pairwise",
  callback = function() { }
)
}
\arguments{
\item{data}{A matrix or data.frame containing multivariate observations,
rows = observations, columns = variables/items}

\item{n.factors}{A number specifying the number of group factors that the items load on}

\item{model}{A string that by default ("balanced") distributes the items evenly
among the number of group factors. This only works if the items are a multiple of
the number of group factors and the items are already grouped in the data set,
meaning, e.g., items 1-5 load on one factor, 6-10 on another, and so on.
A model file can be specified in lavaan syntax style (f1=~.+.+.) to relate the items
to the group factors. The items can either be named as the columns in the data set
or x1, ..., xn, where 1,...,n correspond to the column numbers}

\item{n.iter}{A number for the iterations of the Gibbs Sampler}

\item{n.burnin}{A number for the burnin in the Gibbs Sampler}

\item{n.chains}{A number for the chains to run for the MCMC sampling}

\item{thin}{A number for the thinning of the MCMC samples}

\item{interval}{A number specifying the credible interval,
the interval is the highest posterior desntiy interval (HPD)}

\item{missing}{A string denoting the missing data handling, can be "pairwise" or "listwise.
With pairwise the missing data will be "imputed" during the MCMC sampling
as further unknown parameters}

\item{callback}{An empty function for implementing a progressbar call
from a higher program (e.g., JASP)}
}
\description{
When supplying a data set that is multidimensional
the function estimates the reliability of the set by means of omega-total
and the general factor saturation of the set by means of omega-hierarchical
In the process a higher-order factor model is estimated in the Bayesian framework,
and posterior distributions of omega-t and omega-h are obtained from the
posterior distributions of the factor model parameters
The output contains the posterior distributions of omega-t and omega-h,
their mean and credible intervals.
}
\examples{
# note that the iterations are set very low for smoother running examples, you should use
# at least the defaults
res <- bomegas(upps, n.factors = 5, model = "balanced", n.iter = 200, n.burnin = 50,
n.chains = 2, missing = "listwise")

# or with specified model syntax relating the group factors to the items:
model <- "f1 =~ U17_r + U22_r + U29_r + U34_r
f2 =~ U4 + U14 + U19 + U27
f3 =~ U6 + U16 + U28 + U48
f4 =~ U23_r + U31_r + U36_r + U46_r
f5 =~ U10_r + U20_r + U35_r + U52_r"
res <- bomegas(upps, n.factors = 5, model = model, n.iter = 200, n.burnin = 50,
n.chains = 2, missing = "listwise")

}
\references{
{

\insertRef{Lee2007}{Bayesrel}

}
}
