% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classPrior.R
\name{createUniformPrior}
\alias{createUniformPrior}
\title{Convenience function to create a simple uniform prior distribution}
\usage{
createUniformPrior(lower, upper, best = NULL)
}
\arguments{
\item{lower}{vector of lower prior range for all parameters}

\item{upper}{vector of upper prior range for all parameters}

\item{best}{vector with "best" values for all parameters}
}
\description{
Convenience function to create a simple uniform prior distribution
}
\note{
for details see \code{\link{createPrior}}
}
\examples{
set.seed(1)

prior <- createUniformPrior(lower = c(0,0), upper = c(0.4,5))

# c(2, 3) outside of limits
prior$density(c(2, 3))
# -Inf

# c(0.2, 2) within limits
prior$density(c(0.2, 2))
# -0.6931472


# sample from prior
prior$sampler()
# [1] 0.2291413 4.5410389


## the prior object can be passed to createBayesianSetup()

# log-likelihood density function (needed for createBayesianSetup)
ll <- function(x) sum(dnorm(x, log = TRUE))

setup <- createBayesianSetup(prior = prior, likelihood = ll)
}
\seealso{
\code{\link{createPriorDensity}}, \code{\link{createPrior}}, \code{\link{createBetaPrior}}, \code{\link{createTruncatedNormalPrior}}, \code{\link{createBayesianSetup}}
}
\author{
Florian Hartig
}
